/*
 * Decompiled with CFR 0.152.
 */
package com.dss.shaded.client5.http.entity.mime;

import com.dss.shaded.client5.http.entity.mime.AbstractMultipartFormat;
import com.dss.shaded.client5.http.entity.mime.MimeField;
import com.dss.shaded.client5.http.entity.mime.MultipartPart;
import com.dss.shaded.core5.http.NameValuePair;
import com.dss.shaded.core5.net.PercentCodec;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;

class HttpRFC7578Multipart
extends AbstractMultipartFormat {
    private final List<MultipartPart> parts;

    public HttpRFC7578Multipart(Charset charset, String boundary, List<MultipartPart> parts, String preamble, String epilogue) {
        super(charset, boundary, preamble, epilogue);
        this.parts = parts;
    }

    public HttpRFC7578Multipart(Charset charset, String boundary, List<MultipartPart> parts) {
        this(charset, boundary, parts, null, null);
    }

    @Override
    public List<MultipartPart> getParts() {
        return this.parts;
    }

    @Override
    protected void formatMultipartHeader(MultipartPart part, OutputStream out) throws IOException {
        for (MimeField field : part.getHeader()) {
            if ("Content-Disposition".equalsIgnoreCase(field.getName())) {
                HttpRFC7578Multipart.writeBytes(field.getName(), this.charset, out);
                HttpRFC7578Multipart.writeBytes(FIELD_SEP, out);
                HttpRFC7578Multipart.writeBytes(field.getValue(), out);
                List<NameValuePair> parameters = field.getParameters();
                for (int i = 0; i < parameters.size(); ++i) {
                    NameValuePair parameter = parameters.get(i);
                    String name = parameter.getName();
                    String value = parameter.getValue();
                    HttpRFC7578Multipart.writeBytes("; ", out);
                    HttpRFC7578Multipart.writeBytes(name, out);
                    HttpRFC7578Multipart.writeBytes("=\"", out);
                    if (value != null) {
                        if (name.equalsIgnoreCase("filename") || name.equalsIgnoreCase("filename*")) {
                            String encodedValue = name.equalsIgnoreCase("filename*") ? "UTF-8''" + PercentCodec.RFC5987.encode(value) : PercentCodec.RFC5987.encode(value);
                            byte[] encodedBytes = encodedValue.getBytes(StandardCharsets.US_ASCII);
                            out.write(encodedBytes);
                        } else {
                            HttpRFC7578Multipart.writeBytes(value, out);
                        }
                    }
                    HttpRFC7578Multipart.writeBytes("\"", out);
                }
                HttpRFC7578Multipart.writeBytes(CR_LF, out);
                continue;
            }
            HttpRFC7578Multipart.writeField(field, this.charset, out);
        }
    }
}

