/*
 * Decompiled with CFR 0.152.
 */
package com.dss.shaded.client5.http.impl;

import com.dss.shaded.client5.http.ConnectionKeepAliveStrategy;
import com.dss.shaded.client5.http.config.RequestConfig;
import com.dss.shaded.client5.http.protocol.HttpClientContext;
import com.dss.shaded.core5.annotation.Contract;
import com.dss.shaded.core5.annotation.ThreadingBehavior;
import com.dss.shaded.core5.http.HeaderElement;
import com.dss.shaded.core5.http.HttpResponse;
import com.dss.shaded.core5.http.message.MessageSupport;
import com.dss.shaded.core5.http.protocol.HttpContext;
import com.dss.shaded.core5.util.Args;
import com.dss.shaded.core5.util.TimeValue;
import java.util.Iterator;

@Contract(threading=ThreadingBehavior.STATELESS)
public class DefaultConnectionKeepAliveStrategy
implements ConnectionKeepAliveStrategy {
    public static final DefaultConnectionKeepAliveStrategy INSTANCE = new DefaultConnectionKeepAliveStrategy();

    @Override
    public TimeValue getKeepAliveDuration(HttpResponse response, HttpContext context) {
        Args.notNull(response, "HTTP response");
        Iterator<HeaderElement> it = MessageSupport.iterate(response, "keep-alive");
        while (it.hasNext()) {
            HeaderElement he = it.next();
            String param = he.getName();
            String value = he.getValue();
            if (value == null || !param.equalsIgnoreCase("timeout")) continue;
            try {
                return TimeValue.ofSeconds(Long.parseLong(value));
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        HttpClientContext clientContext = HttpClientContext.cast(context);
        RequestConfig requestConfig = clientContext.getRequestConfigOrDefault();
        return requestConfig.getConnectionKeepAlive();
    }
}

