/*
 * Decompiled with CFR 0.152.
 */
package com.dss.shaded.client5.http.impl;

import com.dss.shaded.client5.http.protocol.RedirectStrategy;
import com.dss.shaded.client5.http.utils.URIUtils;
import com.dss.shaded.core5.annotation.Contract;
import com.dss.shaded.core5.annotation.ThreadingBehavior;
import com.dss.shaded.core5.http.Header;
import com.dss.shaded.core5.http.HttpException;
import com.dss.shaded.core5.http.HttpRequest;
import com.dss.shaded.core5.http.HttpResponse;
import com.dss.shaded.core5.http.ProtocolException;
import com.dss.shaded.core5.http.protocol.HttpContext;
import com.dss.shaded.core5.net.URIBuilder;
import com.dss.shaded.core5.util.Args;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;

@Contract(threading=ThreadingBehavior.STATELESS)
public class DefaultRedirectStrategy
implements RedirectStrategy {
    public static final DefaultRedirectStrategy INSTANCE = new DefaultRedirectStrategy();

    @Override
    public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
        Args.notNull(request, "HTTP request");
        Args.notNull(response, "HTTP response");
        if (!response.containsHeader("Location")) {
            return false;
        }
        int statusCode = response.getCode();
        switch (statusCode) {
            case 301: 
            case 302: 
            case 303: 
            case 307: 
            case 308: {
                return true;
            }
        }
        return false;
    }

    @Override
    public URI getLocationURI(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException {
        Args.notNull(request, "HTTP request");
        Args.notNull(response, "HTTP response");
        Args.notNull(context, "HTTP context");
        Header locationHeader = response.getFirstHeader("Location");
        if (locationHeader == null) {
            throw new HttpException("Redirect location is missing");
        }
        String location = locationHeader.getValue();
        URI uri = this.createLocationURI(location);
        try {
            if (!uri.isAbsolute()) {
                uri = URIUtils.resolve(request.getUri(), uri);
            }
        }
        catch (URISyntaxException ex) {
            throw new ProtocolException(ex.getMessage(), ex);
        }
        return uri;
    }

    protected URI createLocationURI(String location) throws ProtocolException {
        try {
            URIBuilder b = new URIBuilder(new URI(location).normalize());
            String host = b.getHost();
            if (host != null) {
                b.setHost(host.toLowerCase(Locale.ROOT));
            }
            if (b.isPathEmpty()) {
                b.setPathSegments("");
            }
            return b.build();
        }
        catch (URISyntaxException ex) {
            throw new ProtocolException("Invalid redirect URI: " + location, ex);
        }
    }
}

