/*
 * Decompiled with CFR 0.152.
 */
package com.dss.shaded.client5.http.impl.auth;

import com.dss.shaded.client5.http.auth.AuthScope;
import com.dss.shaded.client5.http.auth.Credentials;
import com.dss.shaded.client5.http.auth.CredentialsStore;
import com.dss.shaded.client5.http.impl.auth.CredentialsMatcher;
import com.dss.shaded.core5.annotation.Contract;
import com.dss.shaded.core5.annotation.ThreadingBehavior;
import com.dss.shaded.core5.http.protocol.HttpContext;
import com.dss.shaded.core5.util.Args;
import java.util.concurrent.ConcurrentHashMap;

@Contract(threading=ThreadingBehavior.SAFE)
public class BasicCredentialsProvider
implements CredentialsStore {
    private final ConcurrentHashMap<AuthScope, Credentials> credMap = new ConcurrentHashMap();

    @Override
    public void setCredentials(AuthScope authScope, Credentials credentials) {
        Args.notNull(authScope, "Authentication scope");
        this.credMap.put(authScope, credentials);
    }

    @Override
    public Credentials getCredentials(AuthScope authScope, HttpContext context) {
        return CredentialsMatcher.matchCredentials(this.credMap, authScope);
    }

    @Override
    public void clear() {
        this.credMap.clear();
    }

    public String toString() {
        return ((ConcurrentHashMap.CollectionView)((Object)this.credMap.keySet())).toString();
    }
}

