/*
 * Decompiled with CFR 0.152.
 */
package com.dss.shaded.client5.http.impl.classic;

import com.dss.shaded.client5.http.HttpRoute;
import com.dss.shaded.client5.http.impl.classic.AbstractBackoff;
import com.dss.shaded.core5.pool.ConnPoolControl;
import com.dss.shaded.core5.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExponentialBackoffManager
extends AbstractBackoff {
    private static final Logger LOG = LoggerFactory.getLogger(ExponentialBackoffManager.class);

    public ExponentialBackoffManager(ConnPoolControl<HttpRoute> connPerRoute) {
        super(connPerRoute);
    }

    @Override
    protected int getBackedOffPoolSize(int curr) {
        if (curr <= 1) {
            return 1;
        }
        int t = this.getTimeInterval().incrementAndGet();
        int result = Math.max(1, (int)Math.floor((double)curr / Math.pow(1.0 + this.getBackoffFactor().get(), t)));
        if (LOG.isDebugEnabled()) {
            LOG.debug("curr={}, t={}, growthRate={}, result={}", new Object[]{curr, t, this.getBackoffFactor().get(), result});
        }
        return result;
    }

    @Override
    public void setBackoffFactor(double rate) {
        Args.check(rate > 0.0, "Growth rate must be greater than 0.0");
        this.getBackoffFactor().set(rate);
    }
}

