/*
 * Decompiled with CFR 0.152.
 */
package com.dss.shaded.client5.http.impl.io;

import com.dss.shaded.client5.http.impl.io.LenientHttpResponseParser;
import com.dss.shaded.core5.annotation.Contract;
import com.dss.shaded.core5.annotation.ThreadingBehavior;
import com.dss.shaded.core5.http.ClassicHttpResponse;
import com.dss.shaded.core5.http.HttpResponseFactory;
import com.dss.shaded.core5.http.config.Http1Config;
import com.dss.shaded.core5.http.impl.io.DefaultClassicHttpResponseFactory;
import com.dss.shaded.core5.http.io.HttpMessageParser;
import com.dss.shaded.core5.http.io.HttpMessageParserFactory;
import com.dss.shaded.core5.http.message.BasicLineParser;
import com.dss.shaded.core5.http.message.LineParser;

@Contract(threading=ThreadingBehavior.STATELESS)
public class DefaultHttpResponseParserFactory
implements HttpMessageParserFactory<ClassicHttpResponse> {
    public static final DefaultHttpResponseParserFactory INSTANCE = new DefaultHttpResponseParserFactory();
    private final Http1Config h1Config;
    private final LineParser lineParser;
    private final HttpResponseFactory<ClassicHttpResponse> responseFactory;

    public DefaultHttpResponseParserFactory(Http1Config h1Config, LineParser lineParser, HttpResponseFactory<ClassicHttpResponse> responseFactory) {
        this.h1Config = h1Config != null ? h1Config : Http1Config.DEFAULT;
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.responseFactory = responseFactory != null ? responseFactory : DefaultClassicHttpResponseFactory.INSTANCE;
    }

    public DefaultHttpResponseParserFactory(Http1Config h1Config) {
        this(h1Config, null, null);
    }

    public DefaultHttpResponseParserFactory(LineParser lineParser, HttpResponseFactory<ClassicHttpResponse> responseFactory) {
        this(null, lineParser, responseFactory);
    }

    public DefaultHttpResponseParserFactory(HttpResponseFactory<ClassicHttpResponse> responseFactory) {
        this(null, null, responseFactory);
    }

    public DefaultHttpResponseParserFactory() {
        this(null, null, null);
    }

    @Override
    public HttpMessageParser<ClassicHttpResponse> create() {
        return new LenientHttpResponseParser(this.lineParser, this.responseFactory, this.h1Config);
    }

    @Override
    @Deprecated
    public HttpMessageParser<ClassicHttpResponse> create(Http1Config h1Config) {
        return new LenientHttpResponseParser(this.lineParser, this.responseFactory, h1Config);
    }
}

