/*
 * Decompiled with CFR 0.152.
 */
package com.dss.shaded.core5.http;

import com.dss.shaded.core5.http.HttpConnectionMetrics;
import com.dss.shaded.core5.net.InetAddressUtils;
import com.dss.shaded.core5.util.Timeout;
import java.net.SocketAddress;

public abstract class EndpointDetails
implements HttpConnectionMetrics {
    private final SocketAddress remoteAddress;
    private final SocketAddress localAddress;
    private final Timeout socketTimeout;

    protected EndpointDetails(SocketAddress remoteAddress, SocketAddress localAddress, Timeout socketTimeout) {
        this.remoteAddress = remoteAddress;
        this.localAddress = localAddress;
        this.socketTimeout = socketTimeout;
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public abstract long getRequestCount();

    @Override
    public abstract long getResponseCount();

    @Override
    public abstract long getSentBytesCount();

    @Override
    public abstract long getReceivedBytesCount();

    public Timeout getSocketTimeout() {
        return this.socketTimeout;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(90);
        InetAddressUtils.formatAddress(buffer, this.localAddress);
        buffer.append("<->");
        InetAddressUtils.formatAddress(buffer, this.remoteAddress);
        return buffer.toString();
    }
}

