/*
 * Decompiled with CFR 0.152.
 */
package com.dss.shaded.core5.http.impl.io;

import com.dss.shaded.core5.annotation.Internal;
import com.dss.shaded.core5.util.Args;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLSocket;

public class SocketHolder {
    private final SSLSocket sslSocket;
    private final Socket baseSocket;
    private final AtomicReference<InputStream> inputStreamRef;
    private final AtomicReference<OutputStream> outputStreamRef;

    public SocketHolder(SSLSocket sslSocket, Socket baseSocket) {
        this.sslSocket = Args.notNull(sslSocket, "SSL Socket");
        this.baseSocket = Args.notNull(baseSocket, "Socket");
        this.inputStreamRef = new AtomicReference();
        this.outputStreamRef = new AtomicReference();
    }

    public SocketHolder(Socket socket) {
        this.baseSocket = Args.notNull(socket, "Socket");
        this.sslSocket = null;
        this.inputStreamRef = new AtomicReference();
        this.outputStreamRef = new AtomicReference();
    }

    public final Socket getSocket() {
        return this.sslSocket != null ? this.sslSocket : this.baseSocket;
    }

    @Internal
    public Socket getBaseSocket() {
        return this.baseSocket;
    }

    @Internal
    public SSLSocket getSSLSocket() {
        return this.sslSocket;
    }

    public final InputStream getInputStream() throws IOException {
        InputStream local = this.inputStreamRef.get();
        if (local != null) {
            return local;
        }
        local = this.getInputStream(this.getSocket());
        if (this.inputStreamRef.compareAndSet(null, local)) {
            return local;
        }
        return this.inputStreamRef.get();
    }

    protected InputStream getInputStream(Socket socket) throws IOException {
        return socket.getInputStream();
    }

    protected OutputStream getOutputStream(Socket socket) throws IOException {
        return socket.getOutputStream();
    }

    public final OutputStream getOutputStream() throws IOException {
        OutputStream local = this.outputStreamRef.get();
        if (local != null) {
            return local;
        }
        local = this.getOutputStream(this.getSocket());
        if (this.outputStreamRef.compareAndSet(null, local)) {
            return local;
        }
        return this.outputStreamRef.get();
    }

    public String toString() {
        return "SocketHolder{sslSocket=" + this.sslSocket + ", baseSocket=" + this.baseSocket + '}';
    }
}

