/*
 * Decompiled with CFR 0.152.
 */
package com.dss.shaded.core5.http.impl.nio;

import com.dss.shaded.core5.http.HttpException;
import com.dss.shaded.core5.http.HttpRequest;
import com.dss.shaded.core5.http.HttpRequestFactory;
import com.dss.shaded.core5.http.MessageConstraintException;
import com.dss.shaded.core5.http.RequestHeaderFieldsTooLargeException;
import com.dss.shaded.core5.http.config.Http1Config;
import com.dss.shaded.core5.http.impl.nio.AbstractMessageParser;
import com.dss.shaded.core5.http.message.LineParser;
import com.dss.shaded.core5.http.message.RequestLine;
import com.dss.shaded.core5.http.nio.SessionInputBuffer;
import com.dss.shaded.core5.util.Args;
import com.dss.shaded.core5.util.CharArrayBuffer;
import java.io.IOException;

public class DefaultHttpRequestParser<T extends HttpRequest>
extends AbstractMessageParser<T> {
    private final HttpRequestFactory<T> requestFactory;

    public DefaultHttpRequestParser(Http1Config http1Config, LineParser parser, HttpRequestFactory<T> requestFactory) {
        super(http1Config, parser);
        this.requestFactory = Args.notNull(requestFactory, "Request factory");
    }

    public DefaultHttpRequestParser(Http1Config http1Config, HttpRequestFactory<T> requestFactory) {
        this(http1Config, null, requestFactory);
    }

    @Deprecated
    public DefaultHttpRequestParser(HttpRequestFactory<T> requestFactory, Http1Config http1Config) {
        this(requestFactory, null, http1Config);
    }

    @Deprecated
    public DefaultHttpRequestParser(HttpRequestFactory<T> requestFactory, LineParser parser, Http1Config http1Config) {
        this(http1Config, parser, requestFactory);
    }

    public DefaultHttpRequestParser(HttpRequestFactory<T> requestFactory) {
        this(null, null, requestFactory);
    }

    @Override
    public T parse(SessionInputBuffer sessionBuffer, boolean endOfStream) throws IOException, HttpException {
        try {
            return (T)((HttpRequest)super.parse(sessionBuffer, endOfStream));
        }
        catch (MessageConstraintException ex) {
            throw new RequestHeaderFieldsTooLargeException(ex.getMessage(), ex);
        }
    }

    @Override
    protected T createMessage(CharArrayBuffer buffer) throws HttpException {
        RequestLine requestLine = this.getLineParser().parseRequestLine(buffer);
        T request = this.requestFactory.newHttpRequest(requestLine.getMethod(), requestLine.getUri());
        request.setVersion(requestLine.getProtocolVersion());
        return request;
    }
}

