/*
 * Decompiled with CFR 0.152.
 */
package com.dss.shaded.core5.http.io.support;

import com.dss.shaded.core5.annotation.Contract;
import com.dss.shaded.core5.annotation.ThreadingBehavior;
import com.dss.shaded.core5.http.ClassicHttpRequest;
import com.dss.shaded.core5.http.Header;
import com.dss.shaded.core5.http.HttpEntity;
import com.dss.shaded.core5.http.HttpException;
import com.dss.shaded.core5.http.HttpResponse;
import com.dss.shaded.core5.http.io.HttpFilterChain;
import com.dss.shaded.core5.http.io.HttpFilterHandler;
import com.dss.shaded.core5.http.io.entity.EntityUtils;
import com.dss.shaded.core5.http.io.entity.StringEntity;
import com.dss.shaded.core5.http.message.BasicClassicHttpResponse;
import com.dss.shaded.core5.http.protocol.HttpContext;
import com.dss.shaded.core5.net.URIAuthority;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.STATELESS)
public abstract class AbstractHttpServerAuthFilter<T>
implements HttpFilterHandler {
    private final boolean respondImmediately;

    protected AbstractHttpServerAuthFilter(boolean respondImmediately) {
        this.respondImmediately = respondImmediately;
    }

    protected abstract T parseChallengeResponse(String var1, HttpContext var2) throws HttpException;

    protected abstract boolean authenticate(T var1, URIAuthority var2, String var3, HttpContext var4);

    protected abstract String generateChallenge(T var1, URIAuthority var2, String var3, HttpContext var4);

    protected HttpEntity generateResponseContent(HttpResponse unauthorized) {
        return new StringEntity("Unauthorized");
    }

    @Override
    public final void handle(ClassicHttpRequest request, HttpFilterChain.ResponseTrigger responseTrigger, HttpContext context, HttpFilterChain chain) throws HttpException, IOException {
        boolean expectContinue;
        Header h = request.getFirstHeader("Authorization");
        T challengeResponse = h != null ? (T)this.parseChallengeResponse(h.getValue(), context) : null;
        URIAuthority authority = request.getAuthority();
        String requestUri = request.getRequestUri();
        boolean authenticated = this.authenticate(challengeResponse, authority, requestUri, context);
        Header expect = request.getFirstHeader("Expect");
        boolean bl = expectContinue = expect != null && "100-continue".equalsIgnoreCase(expect.getValue());
        if (authenticated) {
            if (expectContinue) {
                responseTrigger.sendInformation(new BasicClassicHttpResponse(100));
            }
            chain.proceed(request, responseTrigger, context);
        } else {
            BasicClassicHttpResponse unauthorized = new BasicClassicHttpResponse(401);
            unauthorized.addHeader("WWW-Authenticate", this.generateChallenge(challengeResponse, authority, requestUri, context));
            HttpEntity responseContent = this.generateResponseContent(unauthorized);
            unauthorized.setEntity(responseContent);
            if (this.respondImmediately || expectContinue || request.getEntity() == null) {
                responseTrigger.submitResponse(unauthorized);
                EntityUtils.consume(request.getEntity());
            } else {
                EntityUtils.consume(request.getEntity());
                responseTrigger.submitResponse(unauthorized);
            }
        }
    }
}

