/*
 * Decompiled with CFR 0.152.
 */
package com.dss.shaded.core5.http.nio.entity;

import com.dss.shaded.core5.annotation.Contract;
import com.dss.shaded.core5.annotation.ThreadingBehavior;
import com.dss.shaded.core5.http.ContentType;
import com.dss.shaded.core5.http.nio.AsyncEntityProducer;
import com.dss.shaded.core5.http.nio.DataStreamChannel;
import com.dss.shaded.core5.http.nio.StreamChannel;
import com.dss.shaded.core5.util.Args;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public abstract class AbstractBinAsyncEntityProducer
implements AsyncEntityProducer {
    private final int fragmentSizeHint;
    private final ByteBuffer byteBuffer;
    private final ContentType contentType;
    private final ReentrantLock lock;
    private volatile State state;

    public AbstractBinAsyncEntityProducer(int fragmentSizeHint, ContentType contentType) {
        this.fragmentSizeHint = fragmentSizeHint >= 0 ? fragmentSizeHint : 0;
        this.byteBuffer = ByteBuffer.allocate(this.fragmentSizeHint);
        this.contentType = contentType;
        this.state = State.ACTIVE;
        this.lock = new ReentrantLock();
    }

    private void flush(StreamChannel<ByteBuffer> channel) throws IOException {
        if (this.byteBuffer.position() > 0) {
            this.byteBuffer.flip();
            channel.write(this.byteBuffer);
            this.byteBuffer.compact();
        }
    }

    final int writeData(StreamChannel<ByteBuffer> channel, ByteBuffer src) throws IOException {
        int chunk = src.remaining();
        if (chunk == 0) {
            return 0;
        }
        if (chunk > this.fragmentSizeHint) {
            this.flush(channel);
            if (this.byteBuffer.position() == 0) {
                return channel.write(src);
            }
        } else {
            if (this.byteBuffer.remaining() < chunk) {
                this.flush(channel);
            }
            if (this.byteBuffer.remaining() >= chunk) {
                this.byteBuffer.put(src);
                if (!this.byteBuffer.hasRemaining()) {
                    this.flush(channel);
                }
                return chunk;
            }
        }
        return 0;
    }

    final void streamEnd(StreamChannel<ByteBuffer> channel) throws IOException {
        if (this.state == State.ACTIVE) {
            this.state = State.FLUSHING;
            this.flush(channel);
            if (this.byteBuffer.position() == 0) {
                this.state = State.END_STREAM;
                channel.endStream();
            }
        }
    }

    protected abstract int availableData();

    protected abstract void produceData(StreamChannel<ByteBuffer> var1) throws IOException;

    @Override
    public final String getContentType() {
        return Objects.toString(this.contentType, null);
    }

    @Override
    public String getContentEncoding() {
        return null;
    }

    @Override
    public boolean isChunked() {
        return false;
    }

    @Override
    public Set<String> getTrailerNames() {
        return Collections.emptySet();
    }

    @Override
    public long getContentLength() {
        return -1L;
    }

    @Override
    public final int available() {
        if (this.state == State.ACTIVE) {
            return this.availableData();
        }
        this.lock.lock();
        try {
            int n = this.byteBuffer.position();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public final void produce(final DataStreamChannel channel) throws IOException {
        this.lock.lock();
        try {
            if (this.state == State.ACTIVE) {
                this.produceData(new StreamChannel<ByteBuffer>(){

                    @Override
                    public int write(ByteBuffer src) throws IOException {
                        Args.notNull(src, "Buffer");
                        AbstractBinAsyncEntityProducer.this.lock.lock();
                        try {
                            int n = AbstractBinAsyncEntityProducer.this.writeData(channel, src);
                            return n;
                        }
                        finally {
                            AbstractBinAsyncEntityProducer.this.lock.unlock();
                        }
                    }

                    @Override
                    public void endStream() throws IOException {
                        AbstractBinAsyncEntityProducer.this.lock.lock();
                        try {
                            AbstractBinAsyncEntityProducer.this.streamEnd(channel);
                        }
                        finally {
                            AbstractBinAsyncEntityProducer.this.lock.unlock();
                        }
                    }
                });
            }
            if (this.state == State.FLUSHING) {
                this.flush(channel);
                if (this.byteBuffer.position() == 0) {
                    this.state = State.END_STREAM;
                    channel.endStream();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void releaseResources() {
        this.state = State.ACTIVE;
    }

    static enum State {
        ACTIVE,
        FLUSHING,
        END_STREAM;

    }
}

