/*
 * Decompiled with CFR 0.152.
 */
package com.dss.shaded.core5.http2.impl.nio;

import com.dss.shaded.core5.annotation.Internal;
import com.dss.shaded.core5.http.Header;
import com.dss.shaded.core5.http.HttpException;
import com.dss.shaded.core5.http.RequestHeaderFieldsTooLargeException;
import com.dss.shaded.core5.http.config.CharCodingConfig;
import com.dss.shaded.core5.http.impl.BasicHttpConnectionMetrics;
import com.dss.shaded.core5.http.nio.AsyncPushConsumer;
import com.dss.shaded.core5.http.nio.AsyncServerExchangeHandler;
import com.dss.shaded.core5.http.nio.HandlerFactory;
import com.dss.shaded.core5.http.nio.command.ExecutableCommand;
import com.dss.shaded.core5.http.protocol.HttpCoreContext;
import com.dss.shaded.core5.http.protocol.HttpProcessor;
import com.dss.shaded.core5.http2.H2ConnectionException;
import com.dss.shaded.core5.http2.H2Error;
import com.dss.shaded.core5.http2.config.H2Config;
import com.dss.shaded.core5.http2.frame.DefaultFrameFactory;
import com.dss.shaded.core5.http2.frame.FrameFactory;
import com.dss.shaded.core5.http2.frame.StreamIdGenerator;
import com.dss.shaded.core5.http2.hpack.HeaderListConstraintException;
import com.dss.shaded.core5.http2.impl.nio.AbstractH2StreamMultiplexer;
import com.dss.shaded.core5.http2.impl.nio.H2StreamChannel;
import com.dss.shaded.core5.http2.impl.nio.H2StreamHandler;
import com.dss.shaded.core5.http2.impl.nio.H2StreamListener;
import com.dss.shaded.core5.http2.impl.nio.ServerH2StreamHandler;
import com.dss.shaded.core5.reactor.ProtocolIOSession;
import com.dss.shaded.core5.util.Args;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;

@Internal
public class ServerH2StreamMultiplexer
extends AbstractH2StreamMultiplexer {
    private final HandlerFactory<AsyncServerExchangeHandler> exchangeHandlerFactory;

    public ServerH2StreamMultiplexer(ProtocolIOSession ioSession, FrameFactory frameFactory, HttpProcessor httpProcessor, HandlerFactory<AsyncServerExchangeHandler> exchangeHandlerFactory, CharCodingConfig charCodingConfig, H2Config h2Config, H2StreamListener streamListener) {
        super(ioSession, frameFactory, StreamIdGenerator.EVEN, httpProcessor, charCodingConfig, h2Config, streamListener);
        this.exchangeHandlerFactory = Args.notNull(exchangeHandlerFactory, "Handler factory");
    }

    public ServerH2StreamMultiplexer(ProtocolIOSession ioSession, HttpProcessor httpProcessor, HandlerFactory<AsyncServerExchangeHandler> exchangeHandlerFactory, CharCodingConfig charCodingConfig, H2Config h2Config) {
        this(ioSession, DefaultFrameFactory.INSTANCE, httpProcessor, exchangeHandlerFactory, charCodingConfig, h2Config, null);
    }

    @Override
    void acceptHeaderFrame() throws H2ConnectionException {
    }

    @Override
    void acceptPushRequest() throws H2ConnectionException {
    }

    @Override
    void acceptPushFrame() throws H2ConnectionException {
        throw new H2ConnectionException(H2Error.PROTOCOL_ERROR, "Push not supported");
    }

    @Override
    H2StreamHandler createRemotelyInitiatedStream(H2StreamChannel channel, HttpProcessor httpProcessor, BasicHttpConnectionMetrics connMetrics, HandlerFactory<AsyncPushConsumer> pushHandlerFactory) throws IOException {
        HttpCoreContext context = HttpCoreContext.create();
        context.setSSLSession(this.getSSLSession());
        context.setEndpointDetails(this.getEndpointDetails());
        return new ServerH2StreamHandler(channel, httpProcessor, connMetrics, this.exchangeHandlerFactory, context);
    }

    @Override
    H2StreamHandler createLocallyInitiatedStream(ExecutableCommand command, H2StreamChannel channel, HttpProcessor httpProcessor, BasicHttpConnectionMetrics connMetrics) throws IOException {
        throw new H2ConnectionException(H2Error.INTERNAL_ERROR, "Illegal attempt to execute a request");
    }

    @Override
    List<Header> decodeHeaders(ByteBuffer payload) throws HttpException {
        try {
            return super.decodeHeaders(payload);
        }
        catch (HeaderListConstraintException ex) {
            throw new RequestHeaderFieldsTooLargeException(ex.getMessage(), ex);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        this.appendState(buf);
        buf.append("]");
        return buf.toString();
    }
}

