/*
 * Decompiled with CFR 0.152.
 */
package com.dss.shaded.core5.http2.ssl;

import com.dss.shaded.core5.http.ssl.TLS;
import com.dss.shaded.core5.http.ssl.TlsCiphers;
import com.dss.shaded.core5.http2.HttpVersionPolicy;
import com.dss.shaded.core5.http2.ssl.ApplicationProtocol;
import com.dss.shaded.core5.reactor.ssl.SSLSessionInitializer;
import com.dss.shaded.core5.util.ReflectionUtils;
import javax.net.ssl.SSLParameters;

public final class H2TlsSupport {
    public static void setEnableRetransmissions(SSLParameters sslParameters, boolean value) {
        ReflectionUtils.callSetter(sslParameters, "EnableRetransmissions", Boolean.TYPE, value);
    }

    @Deprecated
    public static void setApplicationProtocols(SSLParameters sslParameters, String[] values) {
        ReflectionUtils.callSetter(sslParameters, "ApplicationProtocols", String[].class, values);
    }

    public static String[] selectApplicationProtocols(Object attachment) {
        HttpVersionPolicy versionPolicy = attachment instanceof HttpVersionPolicy ? (HttpVersionPolicy)((Object)attachment) : HttpVersionPolicy.NEGOTIATE;
        switch (versionPolicy) {
            case FORCE_HTTP_1: {
                return new String[]{ApplicationProtocol.HTTP_1_1.id};
            }
            case FORCE_HTTP_2: {
                return new String[]{ApplicationProtocol.HTTP_2.id};
            }
        }
        return new String[]{ApplicationProtocol.HTTP_2.id, ApplicationProtocol.HTTP_1_1.id};
    }

    public static SSLParameters enforceRequirements(Object attachment, SSLParameters sslParameters) {
        sslParameters.setProtocols(TLS.excludeWeak(sslParameters.getProtocols()));
        sslParameters.setCipherSuites(TlsCiphers.excludeH2Blacklisted(sslParameters.getCipherSuites()));
        H2TlsSupport.setEnableRetransmissions(sslParameters, false);
        sslParameters.setApplicationProtocols(H2TlsSupport.selectApplicationProtocols(attachment));
        return sslParameters;
    }

    public static SSLSessionInitializer enforceRequirements(Object attachment, SSLSessionInitializer initializer) {
        return (endpoint, sslEngine) -> {
            sslEngine.setSSLParameters(H2TlsSupport.enforceRequirements(attachment, sslEngine.getSSLParameters()));
            if (initializer != null) {
                initializer.initialize(endpoint, sslEngine);
            }
        };
    }
}

