package com.dss.demo;

import com.dss.sdk.api.dto.CoordinateInfo;
import com.dss.sdk.api.dto.DocSignSealInfo;
import com.dss.sdk.api.dto.FileSearchInfo;
import com.dss.sdk.api.dto.LocateCoordinate;
import com.dss.sdk.api.enums.CoordOriginEnum;
import com.dss.sdk.api.enums.SearchStrategyEnum;
import com.dss.sdk.api.enums.SignRuleTypeEnum;
import com.dss.sdk.api.factory.DssApiSdkFactory;
import com.dss.sdk.api.req.form.TextWidgetInfo;
import com.dss.sdk.api.req.form.WidgetData;
import com.dss.sdk.api.req.merge.FileUploadAddDataRequest;
import com.dss.sdk.api.req.merge.FileUploadSignRequest;
import com.dss.sdk.api.resp.FileGetFileInfoResponse;
import com.dss.sdk.api.resp.FileSignSignResponse;
import com.dss.sdk.exception.ApiException;
import com.dss.sdk.file.FileItem;
import com.dss.sdk.response.DssResponse;
import com.dss.sdk.utils.random.RandomUtil;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * @author Fadada
 */
public class DssApiMergeDemo {
    private static final String host = "https://dss-dev.fadada.com";
    private static final String appId = "765764";
    private static final String appSecret = "lqdnQUZw3u5rQCLznHz7fEvuzdjhs8Es";
    private static final String filePath = "C:\\temp\\d.pdf";

    public static void main(String[] args) throws Exception {
        //初始化
        DssApiSdkFactory.init(host, appId, appSecret);
        //上传文件填充
        uploadPdfAddData();
        //上传文件签署
        uploadPdfSign();
        // 自定义坐标系签署
        uploadSignWithCoordinateInfo();
    }

    public static void uploadPdfAddData() throws ApiException {
        FileUploadAddDataRequest request = new FileUploadAddDataRequest();
        request.setFileName("d.pdf");
        request.setFile(new FileItem(filePath));
        request.setFontSize(28.0f);
        request.setFormFlattening(false);
        //表单域
        List<TextWidgetInfo> list = new ArrayList<>();
        TextWidgetInfo textWidgetInfo = new TextWidgetInfo();
        textWidgetInfo.setPageBegin(1);
        textWidgetInfo.setXs(50.0);
        textWidgetInfo.setYs(50.0);
        textWidgetInfo.setFieldWidth(100.0);
        textWidgetInfo.setFieldHeight(100.0);
        textWidgetInfo.setFieldName("test_add");
        list.add(textWidgetInfo);
        //数据
        List<WidgetData> dataList = new ArrayList<>();
        WidgetData data = new WidgetData();
        data.setFieldName("test_add");
        data.setFieldValue("测试填充");
        dataList.add(data);
        //赋值
        request.setTextWidgetInfos(list);
        request.setWidgetDataInfos(dataList);
        //发起请求
        DssResponse<FileGetFileInfoResponse> response = DssApiSdkFactory.mergeApiClient.uploadFileAddData(request);
        ApiDemoUtils.println(response);
    }

    public static void uploadPdfSign() throws ApiException {
        FileUploadSignRequest request = new FileUploadSignRequest();
        request.setFileName("d.pdf");
        request.setFile(new FileItem(filePath));
        request.setTransactionId(RandomUtil.randomString(32));

        List<DocSignSealInfo> sealInfos = new ArrayList<>();
        DocSignSealInfo info = new DocSignSealInfo();
        info.setCertificateId("478959876122484736");
        info.setSealId("478959868832784384");
        info.setRuleType(SignRuleTypeEnum.KEYWORD_SIGN.getReadValue());

        List<FileSearchInfo> searchInfos = new ArrayList<>();
        FileSearchInfo searchInfo = new FileSearchInfo();
        searchInfo.setKeyWord("商品");
        searchInfo.setKeyWordPolicy(SearchStrategyEnum.LAST.getReadValue());
        searchInfos.add(searchInfo);

        info.setSearchInfos(searchInfos);

        sealInfos.add(info);

        request.setSealInfos(sealInfos);
        //发起请求
        DssResponse<FileSignSignResponse> response = DssApiSdkFactory.mergeApiClient.uploadFileSign(request);
        ApiDemoUtils.println(response);
    }


    /**
     * 自定义坐标系签署
     *
     * @throws ApiException
     */
    public static void uploadSignWithCoordinateInfo() throws ApiException {
        FileUploadSignRequest request = new FileUploadSignRequest();
        String filePath = "D:\\tmp\\A4横版文件.pdf";
        request.setFileName("A4横版文件.pdf");
        request.setFile(new FileItem(filePath));
        request.setTransactionId(RandomUtil.randomString(32));
        // 指定自定义坐标系，坐标系原点为左下角，坐标尺寸为595.0像素
        request.setCoordinateInfo(new CoordinateInfo(595.0, CoordOriginEnum.LEFT_BOTTOM.getCode()));

        List<DocSignSealInfo> sealInfos = new ArrayList<>();
        DocSignSealInfo info = new DocSignSealInfo();
        info.setCertificateId("491968674759979008");
        info.setSealId("478516737198579712");
        info.setRuleType(SignRuleTypeEnum.LOCATION_SIGN.getReadValue());
        LocateCoordinate locateCoordinate = new LocateCoordinate();
        locateCoordinate.setPageNum(1);
        locateCoordinate.setX(698.0); // 自定义坐标系下的 x坐标值
        locateCoordinate.setY(136.0); // 自定义坐标系下的 y坐标值
        info.setLocateCoordinates(Arrays.asList(locateCoordinate));
        sealInfos.add(info);

        request.setSealInfos(sealInfos);
        //发起请求
        DssResponse<FileSignSignResponse> response = DssApiSdkFactory.mergeApiClient.uploadFileSign(request);
        ApiDemoUtils.println(response);
    }

}
