package com.dss.demo;
import com.dss.sdk.api.dto.*;
import com.dss.sdk.api.enums.SignRuleTypeEnum;
import com.dss.sdk.api.req.evidence.SelfVerificationInfo;

import java.util.ArrayList;
import java.util.Arrays;

import com.dss.sdk.api.factory.DssApiSdkFactory;
import com.dss.sdk.api.req.FileSignUrlRequest;
import com.dss.sdk.api.req.SealCreateDrawResultRequest;
import com.dss.sdk.api.req.SealCreateDrawUrlRequest;
import com.dss.sdk.api.resp.FileSignUrlResponse;
import com.dss.sdk.api.resp.SealCreateDrawResultResponse;
import com.dss.sdk.api.resp.SealCreateDrawUrlResponse;
import com.dss.sdk.exception.ApiException;
import com.dss.sdk.response.DssResponse;

import static com.dss.demo.DssApiSealDemo.createDrawUrl;

public class DssApiSignDemo {

    private static final String host = "https://dss-dev.fadada.com";
    private static final String appId = "765764";
    private static final String appSecret = "lqdnQUZw3u5rQCLznHz7fEvuzdjhs8Es";
    private static final String filePath = "C:\\temp\\d.pdf";


    public static void main(String[] args) throws ApiException {
        DssApiSdkFactory.init(host, appId, appSecret);

        createFileSignUrl();
    }


    public static void createFileSignUrl() throws ApiException {
        FileSignUrlRequest request = new FileSignUrlRequest();
        request.setTransactionId("TyRARtNdAZhIBX1sssTzEoyqyMGDaDCmffYf6");
        request.setUseCopy(true);
        request.setDocSignInfos(new ArrayList<>());
        DocSignInfo docSignInfo = new DocSignInfo();
        docSignInfo.setFileId("492338925252648960_cpdf");
        // 指定位置备注章
        DocSignRemarkSealInfo locationRemarkSealInfo = new DocSignRemarkSealInfo();
        locationRemarkSealInfo.setCertificateId("492056864220815360");
        locationRemarkSealInfo.setRuleType(SignRuleTypeEnum.LOCATION_SIGN.getReadValue());
        LocateCoordinate locateCoordinate = new LocateCoordinate();
        locateCoordinate.setPageNum(1);
        locateCoordinate.setX(100.0);
        locateCoordinate.setY(200.0);
        locationRemarkSealInfo.setLocateCoordinates(Arrays.asList(locateCoordinate));
        docSignInfo.getRemarkSealInfos().add(locationRemarkSealInfo);
        // 自由拖放备注章
        DocSignRemarkSealInfo freeRemarkSealInfo = new DocSignRemarkSealInfo();
        freeRemarkSealInfo.setCertificateId("492056864220815360");
        docSignInfo.getRemarkSealInfos().add(freeRemarkSealInfo);
        //手绘印章
        DocSignHandwriteSealInfo handwriteSealInfo = new DocSignHandwriteSealInfo();
        handwriteSealInfo.setCertificateId("492056864220815360");
        docSignInfo.setHandwriteSealInfo(handwriteSealInfo);
        request.getDocSignInfos().add(docSignInfo);
        DssResponse<FileSignUrlResponse> response = DssApiSdkFactory.fileSignClient.fileSignUrl(request);
        ApiDemoUtils.println(response);
    }


}
