package com.dss.sdk.api.base;

import com.dss.sdk.exception.ApiException;
import com.dss.sdk.request.DssRequest;
import com.dss.sdk.response.DssEntityResponse;
import com.dss.sdk.response.DssResponse;

import java.util.List;

/**
 * 客户端
 *
 * @author Fadada
 */
public interface FddClient {
    /**
     * 执行公开API请求。
     *
     * @param <T>     具体的API响应类
     * @param request 具体的API请求类
     * @return 具体的API响应
     */
    <T> DssResponse<T> execute(DssRequest request, String apiPath, Class<T> clzz) throws ApiException;

    /**
     * 执行公开API LIST请求。
     *
     * @param <T>     具体的API响应类
     * @param request 具体的API请求类
     * @return 具体的API响应
     */
    <T> DssResponse<List<T>> executeList(DssRequest request, String apiPath, Class<T> clzz) throws ApiException;

    /**
     * 执行公开API下载请求。
     *
     * @param request 具体的API请求类
     * @return 具体的API响应
     */
    DssResponse<DssEntityResponse> executeDownload(DssRequest request, String apiPath) throws ApiException;
}
