package com.dss.sdk.api.client;


import com.dss.sdk.api.base.BaseApi;
import com.dss.sdk.api.req.form.FileFormRequest;
import com.dss.sdk.api.req.operate.*;
import com.dss.sdk.api.resp.*;
import com.dss.sdk.api.service.DssClientService;
import com.dss.sdk.constants.ApiUrlConstants;
import com.dss.sdk.exception.ApiException;
import com.dss.sdk.response.DssResponse;
import lombok.extern.slf4j.Slf4j;

/**
 * @author Fadada
 */
public class FileOperateClient extends BaseApi {

    public FileOperateClient(DssClientService clientService) {
        super(clientService);
    }

    //  表单数据转换
    public DssResponse<FileGetFileInfoResponse> addWidgetsAndFill(FileFormRequest formRequest) throws ApiException {
        return clientService.execute(formRequest, ApiUrlConstants.addWidgetsAndFill, FileGetFileInfoResponse.class);
    }

    // 文本框组件
    public DssResponse<FileGetFileInfoResponse> addText(FileFormRequest formRequest) throws ApiException {
        return clientService.execute(formRequest, ApiUrlConstants.addText, FileGetFileInfoResponse.class);
    }

    // 单选框组件
    public DssResponse<FileGetFileInfoResponse> addRadio(FileFormRequest formRequest) throws ApiException {
        return clientService.execute(formRequest, ApiUrlConstants.addRadio, FileGetFileInfoResponse.class);
    }

    // 复选框组件
    public DssResponse<FileGetFileInfoResponse> addCheckbox(FileFormRequest formRequest) throws ApiException {
        return clientService.execute(formRequest, ApiUrlConstants.addCheckbox, FileGetFileInfoResponse.class);
    }

    // 表格组件
    public DssResponse<FileGetFileInfoResponse> addTable(FileFormRequest formRequest) throws ApiException {
        return clientService.execute(formRequest, ApiUrlConstants.addTable, FileGetFileInfoResponse.class);
    }

    //  添加数据
    public DssResponse<FileGetFileInfoResponse> addData(FileFormRequest formRequest) throws ApiException {
        return clientService.execute(formRequest, ApiUrlConstants.addData, FileGetFileInfoResponse.class);
    }

    //  添加图片组件
    public DssResponse<FileGetFileInfoResponse> addImage(FileFormRequest formRequest) throws ApiException {
        return clientService.execute(formRequest, ApiUrlConstants.addImage, FileGetFileInfoResponse.class);
    }

    public DssResponse<FileGetFileInfoResponse> addSign(FileFormRequest formRequest) throws ApiException {
        return clientService.execute(formRequest, ApiUrlConstants.addSign, FileGetFileInfoResponse.class);
    }

    // 获取关键字位置
    public DssResponse<SearchKeywordResponse> searchKeyword(SearchKeywordRequest keywordRequest) throws ApiException {
        return clientService.execute(keywordRequest, ApiUrlConstants.searchKeyword, SearchKeywordResponse.class);
    }

    //  添加水印
    public DssResponse<FileGetFileInfoResponse> addWatermark(AddWatermarkRequest watermarkRequest) throws ApiException {
        return clientService.execute(watermarkRequest, ApiUrlConstants.addWatermark, FileGetFileInfoResponse.class);
    }

    public DssResponse<FileGetFileInfoResponse> mergeFile(MergeFileRequest mergeRequest) throws ApiException {
        return clientService.execute(mergeRequest, ApiUrlConstants.mergeFile, FileGetFileInfoResponse.class);
    }

    public DssResponse<FileGetFileInfoResponse> appendOfd(AppendOfdRequest appendOfdRequest) throws ApiException {
        return clientService.execute(appendOfdRequest, ApiUrlConstants.appendOfd, FileGetFileInfoResponse.class);
    }

    public DssResponse<FileFormUrlResponse> fileFormUrl(FileFormUrlRequest formUrlRequest) throws ApiException {
        return clientService.execute(formUrlRequest, ApiUrlConstants.fileFormUrl, FileFormUrlResponse.class);
    }

    public DssResponse<FileFormWidgetResponse> fileFormWidget(FileFormWidgetRequest fileWidgetRequest) throws ApiException {
        return clientService.execute(fileWidgetRequest, ApiUrlConstants.fileFormWidget, FileFormWidgetResponse.class);
    }

    public DssResponse<FileFormResultResponse> fileFormResult(FileFormResultRequest formResultRequest) throws ApiException {
        return clientService.execute(formResultRequest, ApiUrlConstants.fileFormResult, FileFormResultResponse.class);
    }

}
