package com.dss.sdk.api.client;

import com.dss.sdk.api.base.BaseApi;
import com.dss.sdk.api.req.*;
import com.dss.sdk.api.resp.FileDeleteResponse;
import com.dss.sdk.api.resp.FileGetFileInfoResponse;
import com.dss.sdk.api.resp.FileRegisterResponse;
import com.dss.sdk.api.service.DssClientService;
import com.dss.sdk.constants.ApiUrlConstants;
import com.dss.sdk.exception.ApiException;
import com.dss.sdk.response.DssEntityResponse;
import com.dss.sdk.response.DssResponse;
import lombok.extern.slf4j.Slf4j;


/**
 * @author Fadada
 */
public class FileTransferClient extends BaseApi {

    public FileTransferClient(DssClientService clientService) {
        super(clientService);
    }

    /**
     * POST /filePre/api/upload : 文件上传（含文件转换）
     *
     * @param fileUploadRequest
     * @return 成功 (status code 200)
     */
    public DssResponse<FileGetFileInfoResponse> filePreUpload(FileUploadRequest fileUploadRequest) throws ApiException {
        return clientService.execute(fileUploadRequest, ApiUrlConstants.filePreUpload, FileGetFileInfoResponse.class);
    }

    public DssResponse<DssEntityResponse> downloadStream(FileDownloadRequest fileDownloadRequest) throws ApiException {
        return clientService.executeDownload(fileDownloadRequest, ApiUrlConstants.downloadStream);
    }


    /**
     * POST /api/file/info : 查询文件信息
     * 接口说明：提供通过“文件上传”接口返回的原文件id，可查询该文件转换后的pdf或ofd文件id 适用场景：针文件上传相关接口pdf或ofd转换结果查询。
     *
     * @param fileGetFileInfoRequest (optional)
     * @return 成功 (status code 200)
     */
    public DssResponse<FileGetFileInfoResponse> getFileInfo(FileGetFileInfoRequest fileGetFileInfoRequest) throws ApiException {
        return clientService.execute(fileGetFileInfoRequest, ApiUrlConstants.getFileInfo, FileGetFileInfoResponse.class);
    }

    /**
     * POST /api/file/register : 文件注册
     * 接口说明：提供文件id，可将普通文件注册到，签署文件存储系统，用于签署。
     *
     * @param fileUploadRequest (optional)
     * @return 成功 (status code 200)
     */
    public DssResponse<FileRegisterResponse> prepareFile(FileRegisterRequest fileUploadRequest) throws ApiException {
        return clientService.execute(fileUploadRequest, ApiUrlConstants.prepareFile, FileRegisterResponse.class);
    }

    /**
     * POST /api/file/delete : 文件删除
     *
     * @param fileDeleteRequest 文件删除请求
     * @return 文件删除响应
     * @throws ApiException API异常
     */
    public DssResponse<FileDeleteResponse> deleteFile(FileDeleteRequest fileDeleteRequest) throws ApiException {
        return clientService.execute(fileDeleteRequest, ApiUrlConstants.deleteFile, FileDeleteResponse.class);
    }

}
