package com.dss.sdk.api.client;


import com.dss.sdk.api.base.BaseApi;
import com.dss.sdk.api.req.FileVerifyRequest;
import com.dss.sdk.api.resp.FileVerifyResponse;
import com.dss.sdk.api.service.DssClientService;
import com.dss.sdk.constants.ApiUrlConstants;
import com.dss.sdk.exception.ApiException;
import com.dss.sdk.response.DssResponse;


/**
 * @author Fadada
 */
public class FileVerifyClient extends BaseApi {

    public FileVerifyClient(DssClientService clientService) {
        super(clientService);
    }


    /**
     * POST /fileVerify/api/verify : 文件验签
     * 接口说明：对文件进行验签，或取验签结果。 适用场景：适用于业务系统集成文件验签能力。
     *
     * @param verifyRequest (optional)
     * @return 成功 (status code 200)
     */
    public DssResponse<FileVerifyResponse> fileVerifyVerify(FileVerifyRequest verifyRequest) throws ApiException {
        return clientService.execute(verifyRequest, ApiUrlConstants.fileVerifyVerify, FileVerifyResponse.class);
    }
}
