package com.dss.sdk.api.client;

import com.dss.sdk.api.base.BaseApi;
import com.dss.sdk.api.req.*;
import com.dss.sdk.api.resp.SealCreateDrawResultResponse;
import com.dss.sdk.api.resp.SealCreateDrawUrlResponse;
import com.dss.sdk.api.resp.SealQueryResponse;
import com.dss.sdk.api.resp.SealStyleInfoResponse;
import com.dss.sdk.api.service.DssClientService;
import com.dss.sdk.constants.ApiUrlConstants;
import com.dss.sdk.exception.ApiException;
import com.dss.sdk.response.DssEntityResponse;
import com.dss.sdk.response.DssResponse;

/**
 * @author Fadada
 */
public class SealApiClient extends BaseApi {

    public SealApiClient(DssClientService clientService) {
        super(clientService);
    }

    public DssResponse<DssEntityResponse> previewPerson(SealPreviewRequest sealPreviewRequest) throws ApiException {
        return clientService.executeDownload(sealPreviewRequest, ApiUrlConstants.previewPerson);
    }

    public DssResponse<DssEntityResponse> previewCompany(SealPreviewRequest sealPreviewRequest) throws ApiException {
        return clientService.executeDownload(sealPreviewRequest, ApiUrlConstants.previewCompany);
    }

    public DssResponse<DssEntityResponse> previewRemark(SealRemarkPreviewRequest request) throws ApiException {
        return clientService.executeDownload(request, ApiUrlConstants.previewRemark);
    }

    public DssResponse<DssEntityResponse> download(SealDownloadRequest sealDownloadRequest) throws ApiException {
        return clientService.executeDownload(sealDownloadRequest, ApiUrlConstants.sealDownload);
    }

    /**
     * 制作个人印章
     *
     * @param request 创建模板印章参数
     * @return 印章信息
     */
    public DssResponse<SealStyleInfoResponse> createPerson(SealCreateRequest request) throws ApiException {
        return clientService.execute(request, ApiUrlConstants.createPerson, SealStyleInfoResponse.class);
    }

    /**
     * 制作企业印章
     *
     * @param request 创建模板印章参数
     * @return 印章信息
     */
    public DssResponse<SealStyleInfoResponse> createCompany(SealCreateRequest request) throws ApiException {
        return clientService.execute(request, ApiUrlConstants.createCompany, SealStyleInfoResponse.class);
    }

    /**
     * 创建图片印章
     *
     * @param request 创建图片印章参数
     * @return 印章信息
     */
    public DssResponse<SealStyleInfoResponse> createImage(SealCreateImageRequest request) throws ApiException {
        return clientService.execute(request, ApiUrlConstants.createImage, SealStyleInfoResponse.class);
    }

    /**
     * EUI-制作手绘签名
     *
     * @param request
     * @return
     */
    public DssResponse<SealCreateDrawUrlResponse> createDrawUrl(SealCreateDrawUrlRequest request) throws ApiException {
        return clientService.execute(request, ApiUrlConstants.createDrawUrl, SealCreateDrawUrlResponse.class);
    }

    /**
     * EUI-查询制作手绘签名结果
     *
     * @param request
     * @return
     */
    public DssResponse<SealCreateDrawResultResponse> createDrawResult(SealCreateDrawResultRequest request) throws ApiException {
        return clientService.execute(request, ApiUrlConstants.createDrawResult, SealCreateDrawResultResponse.class);
    }

    /**
     * 查询印章信息
     *
     * @param sealBaseRequest 印章ID
     * @return 印章信息
     */
    public DssResponse<SealStyleInfoResponse> queryInfo(SealBaseRequest sealBaseRequest) throws ApiException {
        return clientService.execute(sealBaseRequest, ApiUrlConstants.queryInfo, SealStyleInfoResponse.class);
    }

    /**
     * 分页查询印章列表
     *
     * @param request 查询条件
     * @return 印章列表
     */
    public DssResponse<SealQueryResponse> queryPage(SealQueryRequest request) throws ApiException {
        return clientService.execute(request, ApiUrlConstants.queryPage, SealQueryResponse.class);
    }

    /**
     * 删除印章
     *
     * @param sealBaseRequest 删除标识
     * @return 删除结果
     */
    public DssResponse delete(SealBaseRequest sealBaseRequest) throws ApiException {
        return clientService.execute(sealBaseRequest, ApiUrlConstants.delete, Void.class);
    }

}
