package com.dss.sdk.api.client;

import com.dss.sdk.api.base.BaseApi;
import com.dss.sdk.api.req.VerifyResultRequest;
import com.dss.sdk.api.req.tool.*;
import com.dss.sdk.api.resp.VerifyResultResponse;
import com.dss.sdk.api.resp.tool.*;
import com.dss.sdk.api.service.DssClientService;
import com.dss.sdk.constants.ApiUrlConstants;
import com.dss.sdk.exception.ApiException;
import com.dss.sdk.response.DssResponse;

/**
 * @author Fadada
 */
public class ToolApiClient extends BaseApi {

    public ToolApiClient(DssClientService clientService) {
        super(clientService);
    }

    /**
     * 身份证OCR
     *
     * @param extendRequest
     * @return
     * @throws ApiException
     */
    public DssResponse<OcrIdCardResponse> ocrIdCard(OcrExtendRequest extendRequest) throws ApiException {
        return clientService.execute(extendRequest, ApiUrlConstants.ocrIdcard, OcrIdCardResponse.class);
    }

    /**
     * 银行卡OCR
     *
     * @param basicRequest
     * @return
     * @throws ApiException
     */
    public DssResponse<OcrBankCardResponse> ocrBankCard(OcrBasicRequest basicRequest) throws ApiException {
        return clientService.execute(basicRequest, ApiUrlConstants.ocrBankcard, OcrBankCardResponse.class);
    }

    /**
     * 驾驶证OCR
     *
     * @param extendRequest
     * @return
     * @throws ApiException
     */
    public DssResponse<OcrDrivingResponse> ocrDriving(OcrExtendRequest extendRequest) throws ApiException {
        return clientService.execute(extendRequest, ApiUrlConstants.ocrDriving, OcrDrivingResponse.class);
    }

    /**
     * 港澳台通行证OCR
     *
     * @param basicRequest
     * @return
     * @throws ApiException
     */
    public DssResponse<OcrMainlandResponse> ocrMainland(OcrBasicRequest basicRequest) throws ApiException {
        return clientService.execute(basicRequest, ApiUrlConstants.ocrMainland, OcrMainlandResponse.class);
    }

    /**
     * 车牌OCR
     *
     * @param extendRequest
     * @return
     * @throws ApiException
     */
    public DssResponse<OcrVechicleResponse> ocrVehicle(OcrExtendRequest extendRequest) throws ApiException {
        return clientService.execute(extendRequest, ApiUrlConstants.ocrVehicle, OcrVechicleResponse.class);
    }

    /**
     * 行驶证OCR
     *
     * @param basicRequest
     * @return
     * @throws ApiException
     */
    public DssResponse<OcrLicenseResponse> ocrLicense(OcrBasicRequest basicRequest) throws ApiException {
        return clientService.execute(basicRequest, ApiUrlConstants.ocrLicense, OcrLicenseResponse.class);
    }

    /**
     * 人脸核验链接
     *
     * @param apiFaceUrlRequest
     * @return
     * @throws ApiException
     */
    public DssResponse<ApiFaceUrlResponse> apiFaceUrl(ApiFaceUrlRequest apiFaceUrlRequest) throws ApiException {
        return clientService.execute(apiFaceUrlRequest, ApiUrlConstants.toolFaceUrl, ApiFaceUrlResponse.class);
    }

    /**
     * 人脸核验结果
     *
     * @param request
     * @return
     * @throws ApiException
     */
    public DssResponse<VerifyResultResponse> apiFaceResult(VerifyResultRequest request) throws ApiException {
        return clientService.execute(request, ApiUrlConstants.toolFaceResult, VerifyResultResponse.class);
    }

    /**
     * 获取互动视频下载链接
     *
     * @param downloadRequest
     * @return
     * @throws ApiException
     */
    public DssResponse<VideoDownloadResponse> getVideoInfo(VideoDownloadRequest downloadRequest) throws ApiException {
        return clientService.execute(downloadRequest, ApiUrlConstants.toolVideoInfo, VideoDownloadResponse.class);
    }

    /**
     * 个人二要素校验
     *
     * @param twoElementRequest
     * @return
     * @throws ApiException
     */
    public DssResponse<TwoElementResultResponse> twoElement(TwoElementRequest twoElementRequest) throws ApiException {
        return clientService.execute(twoElementRequest, ApiUrlConstants.twoElement, TwoElementResultResponse.class);
    }

}
