package com.dss.sdk.api.client;

import com.dss.sdk.api.base.BaseApi;
import com.dss.sdk.api.req.*;
import com.dss.sdk.api.resp.*;
import com.dss.sdk.api.service.DssClientService;
import com.dss.sdk.constants.ApiUrlConstants;
import com.dss.sdk.exception.ApiException;
import com.dss.sdk.response.DssEntityResponse;
import com.dss.sdk.response.DssResponse;

/**
 * @author Fadada
 */
public class ZxcaApiClient extends BaseApi {

    public ZxcaApiClient(DssClientService clientService) {
        super(clientService);
    }

    public DssResponse<CertApplyResponse> applyPerson(CertApplyPersonRequest certApplyPersonRequest) throws ApiException {
        return clientService.execute(certApplyPersonRequest, ApiUrlConstants.applyPerson, CertApplyResponse.class);
    }

    public DssResponse<CertApplyResponse> applyCompany(CertApplyCompanyRequest request) throws ApiException {
        return clientService.execute(request, ApiUrlConstants.applyCompany, CertApplyResponse.class);
    }

    public DssResponse<CertApplyResponse> applyUrl(ZxcaWebUrlRequest request) throws ApiException {
        return clientService.execute(request, ApiUrlConstants.applyUrl, CertApplyResponse.class);
    }

    public DssResponse<CertApplyResponse> applyMultipleUrl(ZxcaWebMultipleUrlRequest request) throws ApiException {
        return clientService.execute(request, ApiUrlConstants.applyMultipleUrl, CertApplyResponse.class);
    }


    public DssResponse<CertApplyInfoResponse> queryCertApply(CertApplyBaseRequest certApplyBaseRequest) throws ApiException {
        return clientService.execute(certApplyBaseRequest, ApiUrlConstants.queryCertApply, CertApplyInfoResponse.class);
    }

    public DssResponse<CertInfoResponse> queryCertInfo(CertInfoRequest request) throws ApiException {
        return clientService.execute(request, ApiUrlConstants.queryCertInfo, CertInfoResponse.class);
    }

    public DssResponse<ZxcaUserDetailResponse> queryPersonInfo(ZxcaUserDetailRequest request) throws ApiException {
        return clientService.execute(request, ApiUrlConstants.queryPersonInfo, ZxcaUserDetailResponse.class);
    }

    public DssResponse<ZxcaCorpDetailResponse> queryCompanyInfo(ZxcaUserDetailRequest request) throws ApiException {
        return clientService.execute(request, ApiUrlConstants.queryCompanyInfo, ZxcaCorpDetailResponse.class);
    }

    public DssResponse<CertApplyInfoResponse> raCertApplyPerson(RaCertApplyPersonRequest raCertApplyPersonRequest) throws ApiException {
        return clientService.execute(raCertApplyPersonRequest, ApiUrlConstants.raCertApplyPerson, CertApplyInfoResponse.class);
    }

    public DssResponse<CertApplyInfoResponse> raCertApplyCompany(RaCertApplyCompanyRequest raCertApplyCompanyRequest) throws ApiException {
        return clientService.execute(raCertApplyCompanyRequest, ApiUrlConstants.raCertApplyCompany, CertApplyInfoResponse.class);
    }

    public DssResponse<ZxcaFileUploadResponse> filePreUpload(ZxcaFileUploadRequest fileUploadRequest) throws ApiException {
        return clientService.execute(fileUploadRequest, ApiUrlConstants.certUpload, ZxcaFileUploadResponse.class);
    }

    public DssResponse<DssEntityResponse> download(ZxcaImageDownloadRequest zxcaImageDownloadRequest) throws ApiException {
        return clientService.executeDownload(zxcaImageDownloadRequest, ApiUrlConstants.zxcaDownload);
    }

    public DssResponse<ZxcaTransactionIdResponse> zxcaUserApiTransCreate(ApiUserTransCreateRequest apiUserTransCreateRequest) throws ApiException {
        return clientService.execute(apiUserTransCreateRequest, ApiUrlConstants.zxcaUserApiTransCreate, ZxcaTransactionIdResponse.class);
    }

    public DssResponse<ZxcaFaceUrlResponse> userApiTransFaceUrl(ZxcaApiUserFaceUrlRequest request) throws ApiException {
        return clientService.execute(request, ApiUrlConstants.userApiTransFaceUrl, ZxcaFaceUrlResponse.class);
    }

    public DssResponse<ZxcaPhotoOcrResponse> userApiPhotoOcr(ZxcaApiUserPhotoOcrRequest request) throws ApiException {
        return clientService.execute(request, ApiUrlConstants.userApiPhotoOcr, ZxcaPhotoOcrResponse.class);
    }

    public DssResponse userApiTransVerificationCode(ZxcaApiUserCodeRequest request) throws ApiException {
        return clientService.execute(request, ApiUrlConstants.userApiTransVerificationCode, Void.class);
    }

    public DssResponse<CertApplyInfoResponse> userApiTransMobile(ZxcaApiUserMobileRequest request) throws ApiException {
        return clientService.execute(request, ApiUrlConstants.userApiTransMobile, CertApplyInfoResponse.class);
    }

    public DssResponse<CertApplyInfoResponse> userApiTransBankAccount(ZxcaApiUserBankRequest request) throws ApiException {
        return clientService.execute(request, ApiUrlConstants.userApiTransBankAccount, CertApplyInfoResponse.class);
    }

    public DssResponse<ZxcaGesturePhotoNumResponse> userApiTransGesturePhotoNum(ZxcaApiUserGesturePhotoNumRequest request) throws ApiException {
        return clientService.execute(request, ApiUrlConstants.userApiTransGesturePhotoNum, ZxcaGesturePhotoNumResponse.class);
    }

    public DssResponse userApiTransSubmitAuditMaterials(ZxcaApiUserAuditRequest request) throws ApiException {
        return clientService.execute(request, ApiUrlConstants.userApiTransSubmitAuditMaterials, Void.class);
    }

    public DssResponse userApiTransCancelAuditTicket(ZxcaApiUserCancelAuditRequest request) throws ApiException {
        return clientService.execute(request, ApiUrlConstants.userApiTransCancelAuditTicket, Void.class);
    }

    public DssResponse<CertPageResponse> queryPage(CertPageRequest request) throws ApiException {
        return clientService.execute(request, ApiUrlConstants.verifiedQueryPage, CertPageResponse.class);
    }

    public DssResponse<ZxcaApiCorpTransCreateResponse> corpTransCreate(ApiCorpTransCreateRequest apiCorpTransCreateRequest) throws ApiException {
        return clientService.execute(apiCorpTransCreateRequest, ApiUrlConstants.userApiTransCompany, ZxcaApiCorpTransCreateResponse.class);
    }

    //提交企业信息
    public DssResponse<ZxcaApiCorpTransSubmitResponse> corpTransSubmitInfo(ZxcaApiCorpTransSubmitRequest zxcaApiCorpTransSubmitRequest) throws ApiException {
        return clientService.execute(zxcaApiCorpTransSubmitRequest, ApiUrlConstants.userApiTransCompanyInfo, ZxcaApiCorpTransSubmitResponse.class);
    }

    //选择/切换认证方式
    public DssResponse<ZxcaApiCorpSwitchTypeResponse> corpTransSwitchVerificationType(ZxcaApiCorpSwitchTypeRequest zxcaApiCorpSwitchTypeRequest) throws ApiException {
        return clientService.execute(zxcaApiCorpSwitchTypeRequest, ApiUrlConstants.userApiTransCompanyVerifyType, ZxcaApiCorpSwitchTypeResponse.class);
    }

    //发送短信验证码
    public DssResponse corpTransSendVerificationCode(ZxcaApiCorpSendCodeRequest zxcaApiCorpSendCodeRequest) throws ApiException {
        return clientService.execute(zxcaApiCorpSendCodeRequest, ApiUrlConstants.userApiTransCompanySendCode, Void.class);
    }

    //法定代表人验证-实名手机号验证
    public DssResponse<CertApplyInfoResponse> corpTransLegalRepSelfPhoneVerification(ZxcaApiCorpLegalPhoneVerifyRequest zxcaApiCorpLegalVerifyRequest) throws ApiException {
        return clientService.execute(zxcaApiCorpLegalVerifyRequest, ApiUrlConstants.userApiTransCompanyLegalPhoneVerify, CertApplyInfoResponse.class);
    }

    //法定代表人验证-人脸识别验证
    public DssResponse<ZxcaApiCorpLegalFaceVerifyResponse> corpTransLegalRepSelfFaceVerification(ZxcaApiCorpLegalFaceVerifyRequest zxcaApiCorpLegalVerifyRequest) throws ApiException {
        return clientService.execute(zxcaApiCorpLegalVerifyRequest, ApiUrlConstants.userApiTransCompanyLegalFaceVerify, ZxcaApiCorpLegalFaceVerifyResponse.class);
    }

    //获取法定代表人授权链接
    public DssResponse<ZxcaApiCorpLegalAuthUrlResponse> corpTransGetLegalRepAuthUrl(ZxcaApiCorpLegalAuthUrlRequest zxcaApiCorpLegalAuthUrlRequest) throws ApiException {
        return clientService.execute(zxcaApiCorpLegalAuthUrlRequest, ApiUrlConstants.userApiTransCompanyLegalAuthUrl, ZxcaApiCorpLegalAuthUrlResponse.class);
    }

    //获取授权公函下载链接
    public DssResponse<ZxcaApiCorpLetterUrlResponse> corpTransGetLetterDownloadUrl(ZxcaApiCorpLetterUrlRequest zxcaApiCorpLetterUrlRequest) throws ApiException {
        return clientService.execute(zxcaApiCorpLetterUrlRequest, ApiUrlConstants.userApiTransCompanyLetterDownloadUrl, ZxcaApiCorpLetterUrlResponse.class);
    }

    //提交授权公函审核
    public DssResponse<ZxcaApiCorpSubmitLetterAuditResponse> corpTransSubmitLetterAudit(ZxcaApiCorpSubmitLetterAuditRequest zxcaApiCorpSubmitLetterAuditRequest) throws ApiException {
        return clientService.execute(zxcaApiCorpSubmitLetterAuditRequest, ApiUrlConstants.userApiTransCompanySubmitLetterAudit, ZxcaApiCorpSubmitLetterAuditResponse.class);
    }

    //开户行查询
    public DssResponse<ZxcaApiCorpBankInfoResponse> corpTransQryBankInfo(ZxcaApiCorpBankInfoRequest zxcaApiCorpBankInfoRequest) throws ApiException {
        return clientService.execute(zxcaApiCorpBankInfoRequest, ApiUrlConstants.userApiTransCompanyBankInfo, ZxcaApiCorpBankInfoResponse.class);
    }

    //对公账户验证
    public DssResponse<ZxcaApiCorpBankAccountVerifyResponse> corpTransBankAccountVerify(ZxcaApiCorpBankAccountVerifyRequest zxcaApiCorpBankAccountVerifyRequest) throws ApiException {
        return clientService.execute(zxcaApiCorpBankAccountVerifyRequest, ApiUrlConstants.userApiTransCompanyBankAccountVerify, ZxcaApiCorpBankAccountVerifyResponse.class);
    }

    //打款金额验证
    public DssResponse<ZxcaApiCorpPayAccountVerifyResponse> corpTransPayInAmountVerify(ZxcaApiCorpPayAccountVerifyRequest zxcaApiCorpPayAccountVerifyRequest) throws ApiException {
        return clientService.execute(zxcaApiCorpPayAccountVerifyRequest, ApiUrlConstants.userApiTransCompanyPayAmountVerify, ZxcaApiCorpPayAccountVerifyResponse.class);
    }

    //查询邮寄信息
    public DssResponse<ZxcaApiCorpMailingInfoResponse> corpTransQryMailingInfo(ZxcaApiCorpMailingInfoRequest zxcaApiCorpMailingInfoRequest) throws ApiException {
        return clientService.execute(zxcaApiCorpMailingInfoRequest, ApiUrlConstants.userApiTransCompanyMailInfo, ZxcaApiCorpMailingInfoResponse.class);
    }

}
