package com.dss.sdk.api.client.merge;

import com.dss.sdk.api.base.BaseApi;
import com.dss.sdk.api.req.FileSignSignRequest;
import com.dss.sdk.api.req.FileUploadRequest;
import com.dss.sdk.api.req.form.FileFormRequest;
import com.dss.sdk.api.req.merge.FileUploadAddDataRequest;
import com.dss.sdk.api.req.merge.FileUploadSignRequest;
import com.dss.sdk.api.resp.FileGetFileInfoResponse;
import com.dss.sdk.api.resp.FileSignSignResponse;
import com.dss.sdk.api.service.DssClientService;
import com.dss.sdk.constants.ApiUrlConstants;
import com.dss.sdk.exception.ApiException;
import com.dss.sdk.file.FileItem;
import com.dss.sdk.response.DssResponse;
import com.dss.sdk.stratey.JsonStrategy;

/**
 * @author: Fadada
 */
public class MergeApiClient extends BaseApi {

    public MergeApiClient(DssClientService clientService) {
        super(clientService);
    }

    /**
     * 上传文件+PDF组件内容填充
     *
     * @throws ApiException
     */
    public DssResponse<FileGetFileInfoResponse> uploadFileAddData(FileUploadAddDataRequest request) throws ApiException {
        //客户端不检验参数
        clientService.setNeedCheckRequest(false);
        //获取file
        FileItem fileItem = null;
        if (request.getFile() != null) {
            fileItem = request.getFile();
            request.setFile(null);
        }
        //获取json操作类
        JsonStrategy jsonStrategy = clientService.getJsonStrategy();
        String dataJson = jsonStrategy.toJson(request);
        //参数转换
        FileUploadRequest uploadRequest = jsonStrategy.toBean(dataJson, FileUploadRequest.class);
        FileFormRequest formRequest = jsonStrategy.toBean(dataJson, FileFormRequest.class);
        if (fileItem != null) {
            uploadRequest.setFile(fileItem);
        }
        //上传文件
        DssResponse<FileGetFileInfoResponse> response = clientService.execute(uploadRequest, ApiUrlConstants.filePreUpload, FileGetFileInfoResponse.class);
        if (!response.isSuccess()) {
            throw new ApiException(response.getCode(), response.getMessage());
        }
        //文件id赋值
        formRequest.setFileId(response.getData().getFileId());
        //表单填充
        clientService.setNeedCheckRequest(true);
        return clientService.execute(formRequest, ApiUrlConstants.addData, FileGetFileInfoResponse.class);
    }

    /**
     * 上传文件+文件签署
     *
     * @throws ApiException
     */
    public DssResponse<FileSignSignResponse> uploadFileSign(FileUploadSignRequest request) throws ApiException {
        //客户端不检验参数
        clientService.setNeedCheckRequest(false);
        //获取file
        FileItem fileItem = null;
        if (request.getFile() != null) {
            fileItem = request.getFile();
            request.setFile(null);
        }
        //获取json操作类
        JsonStrategy jsonStrategy = clientService.getJsonStrategy();
        String dataJson = jsonStrategy.toJson(request);
        //参数转换
        FileUploadRequest uploadRequest = jsonStrategy.toBean(dataJson, FileUploadRequest.class);
        FileSignSignRequest signRequest = jsonStrategy.toBean(dataJson, FileSignSignRequest.class);
        //赋值file
        if (fileItem != null) {
            uploadRequest.setFile(fileItem);
        }
        //上传文件
        DssResponse<FileGetFileInfoResponse> response = clientService.execute(uploadRequest, ApiUrlConstants.filePreUpload, FileGetFileInfoResponse.class);
        if (!response.isSuccess()) {
            throw new ApiException(response.getCode(), response.getMessage());
        }
        //文件id赋值
        signRequest.setFileId(response.getData().getFileId());
        //签署文件
        clientService.setNeedCheckRequest(true);
        return clientService.execute(signRequest, ApiUrlConstants.fileSignSign, FileSignSignResponse.class);
    }
}
