package com.dss.sdk.api.dto;

import lombok.Data;
import lombok.RequiredArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

@Data
@Accessors(chain = true)
@RequiredArgsConstructor(staticName = "of")
public class ApiRequestLogDTO implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 跟踪id
     */
    private String traceId;
    /**
     * 接入方APPID
     */
    private String appId;
    /**
     * app名称
     */
    private String appName;
    /**
     * 接口名称
     */
    private String apiName;
    /**
     * 接口路径
     */
    private String apiPath;
    /**
     * 请求方法
     */
    private String apiMethod;
    /**
     * 请求结果返回码
     */
    private String responseCode;
    /**
     * 请求时间
     */
    private Date requestTime;
    /**
     * 响应时间
     */
    private Date responseTime;
    /**
     * 外网IP
     */
    private String clientIp;
    /**
     * 内网IP
     */
    private String internalIp;
    /**
     * api接口请求参数
     */
    private String requestParams;
    /**
     * api接口返回结果
     */
    private String requestResult;
}
