package com.dss.sdk.api.dto;

import com.dss.sdk.api.enums.CoordOriginEnum;


/**
 * 坐标基准信息
 */
@lombok.Data
public class CoordinateInfo {
    /**
     * 坐标参考系，坐标参考系。不同的分辨率影响文件的清晰度以及坐标参考系。
     * 800px（默认）：以分辨率为96时，A4纸宽21厘米=800px作为文档参考系。
     * 595px：以分辨率为72时，A4纸宽21厘米=595px作为文档参考系。
     */
    private Double coordSpec;
    /**
     * 坐标原点，坐标原点。
     * left_top：左上（默认）；
     * left_bottom：左下
     */
    private String coordOrigin = CoordOriginEnum.LEFT_TOP.getCode();

    public CoordinateInfo(Double coordSpec, String coordOrigin) {
        this.coordSpec = coordSpec;
        this.coordOrigin = coordOrigin;
    }

    public CoordinateInfo() {
    }

}