package com.dss.sdk.api.dto;

import java.util.ArrayList;
import java.util.List;

/**
 * DocSignDateSealInfo
 */
@lombok.Data
public class DocSignDateSealInfo {
    private String dateFormatType;
    /**
     * 个人或企业证书唯一识别标识
     */
    private String certificateId;
    /**
     * 2:按照传递的坐标信息签章；3：按照文字查找签章 参见枚举SignRuleTypeEnum
     */
    private String ruleType;
    /**
     * 签章坐标列表
     */
    private List<FileSearchInfo> searchInfos = new ArrayList<>();
    /**
     * 签章坐标列表
     */
    private List<LocateCoordinate> locateCoordinates = new ArrayList<>();
    /**
     * 签名域列表
     */
    private List<SignatureFieldInfo> signatureFieldInfos = new ArrayList<>();
}
