package com.dss.sdk.api.dto;

import java.util.ArrayList;
import java.util.List;


@lombok.Data
public class DocSignHandwriteSealInfo {
    /**
     * 个人证书唯一识别标识
     */
    private String certificateId;

    /**
     * 盖章方式：location:按照传递的坐标信息签章；keyword：按照文字查找签章 参见枚举SignRuleTypeEnum
     */
    private String ruleType;

    /**
     * 签章关键字列表
     */
    private List<FileSearchInfo> searchInfos = new ArrayList<>();

    /**
     * 签署控件坐标列表
     */
    private List<LocateCoordinate> locateCoordinates = new ArrayList<>();

    /**
     * 自定义印章的高，印章的高（单位毫米mm），最大60mm，最小10mm
     */
    private Integer sealHeight = 16;
    /**
     * 自定义印章的宽，印章的宽（单位毫米mm），最大60mm，最小10mm
     */
    private Integer sealWidth = 30;

}

