package com.dss.sdk.api.dto;

import java.util.ArrayList;
import java.util.List;

/**
 * DocSignInfo
 */
@lombok.Data
public class DocSignInfo {
    /**
     * 文件在本地电子签系统的唯一识别标识
     */
    private String fileId;
    private boolean useCopy = false;
    /**
     * 支持传入多组不同位置的个人或企业签章
     */
    private List<DocSignSealInfo> sealInfos = new ArrayList<>();
    /**
     * 详见日期章信息，支持传入多组不同位置的日期章
     */
    private List<DocSignDateSealInfo> dateSealInfos = new ArrayList<>();
    /**
     * 详见骑缝章信息
     */
    private List<DocSignAcrossSealInfo> acrossSealInfos = new ArrayList<>();
    /**
     * 详见备注章信息，支持传入多组不同位置的备注章
     */
    private List<DocSignRemarkSealInfo> remarkSealInfos = new ArrayList<>();
    /**
     * 手写章信息
     */
    private DocSignHandwriteSealInfo handwriteSealInfo;
    //============ 进行业务处理时使用的字段，非请求入参 ============
    // 签署后的文件id
    private String newFileId;
}
