package com.dss.sdk.api.dto;

import java.util.ArrayList;
import java.util.List;

/**
 * DocSignRemarkSealInfo
 */
@lombok.Data
public class DocSignRemarkSealInfo {
    /**
     * 签署备注内容
     */
    private String content;
    /**
     * 个人或企业证书唯一识别标识
     */
    private String certificateId;
    /**
     * 盖章方式：location:按照传递的坐标信息签章；keyword：按照文字查找签章 参见枚举SignRuleTypeEnum
     */
    private String ruleType;
    /**
     * 签章坐标列表
     */
    private List<FileSearchInfo> searchInfos = new ArrayList<>();
    /**
     * 签署备注控件坐标列表
     */
    private List<LocateCoordinate> locateCoordinates = new ArrayList<>();
    /**
     * 签名域列表
     */
    private List<SignatureFieldInfo> signatureFieldInfos = new ArrayList<>();
    /**
     * 备注区高度，默认110（取值范围A4标准12-1131px)（默认内边距5 * 2，最小字体2，所以最小值12）
     */
    private Integer fieldHeight = 110;
    /**
     * 备注区宽度，默认310（取值范围A4标准12-800px)（默认内边距5 * 2，最小字体2，所以最小值12）
     */
    private Integer fieldWidth = 310;
    /**
     * 字体大小，默认10（2-72px）
     */
    private Integer fontSize = 10;
    /**
     * #595959（默认）
     */
    private String fontRgbColor = "#595959";
    /**
     * 文字加粗， regular：不加粗 （默认）； bold：加粗 ；
     */
    private String bold = "regular";
    /**
     * 对齐方式: left：左对齐 （默认）; center：居中; right：右对齐
     */
    private String alignType = "left";
}
