package com.dss.sdk.api.dto;

import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * DocSignSealInfo
 */
@Data
public class DocSignSealInfo {
    /**
     * 个人签名或者企业印章章面
     */
    private String sealId;
    /**
     * 个人或企业证书唯一识别标识
     */
    private String certificateId;
    /**
     * location:按照传递的坐标信息签章；keyword：按照文字查找签章 参见枚举SignRuleTypeEnum
     */
    private String ruleType;
    /**
     * 签章坐标列表
     */
    private List<FileSearchInfo> searchInfos = new ArrayList<>();
    /**
     * 签章坐标列表
     */
    private List<LocateCoordinate> locateCoordinates = new ArrayList<>();
    /**
     * 签名域列表
     */
    private List<SignatureFieldInfo> signatureFieldInfos = new ArrayList<>();
}
