package com.dss.sdk.api.dto;

import com.dss.sdk.api.enums.SearchStrategyEnum;
import lombok.Data;

@Data
public class FileSearchInfo {
    /**
     * 定位关键字
     */
    private String keyWord;
    /**
     * 定位关键字策略， all：所有关键字签章 （默认）；  first：第一个关键字签章 ；  last：最后一个关键字签章；
     */
    private String keyWordPolicy = SearchStrategyEnum.ALL.getReadValue();
    /**
     * 关键字X轴偏移量,默认为0.00，不偏移。正数向右，负数向左
     */
    private double offsetX = 0;
    /**
     * 关键字Y轴偏移量,默认为0.00，不偏移。正数向下，负数向上
     */
    private double offsetY = 0;
}