package com.dss.sdk.api.dto;

import lombok.Data;

/**
 * FileVerifySignatureInfo
 */
@Data
public class FileVerifySignatureInfo {
    /**
     * 签章域的名称，唯一id
     */
    private String name;
    /**
     * 证书颁发机构
     */
    private String organization;
    /**
     * 签章是否覆盖整个pdf文档，可判断是否是最新时间的签章
     */
    private Boolean coversFlag;
    /**
     * 内容是否完整 true-完整，false-被篡改
     */
    private Boolean integrityFlag;
    /**
     * 签章版本，第1次签的Version为1，第2次则为2……
     */
    private Long signVersion;
    /**
     * 总共有几个版本，即签章数量
     */
    private Long totalVersion;
    /**
     * 数字证书信息DN中的CN
     */
    private String signer;
    /**
     * 签名人证书编号/序列号
     */
    private String signNo;
    /**
     * 签章时间
     */
    private String signTime;
    /**
     * hash摘要算法
     */
    private String hashAlgorithm;
    /**
     * 加密算法
     */
    private String encryptAlgorithm;
    /**
     * 地点
     */
    private String location;
    /**
     * 原因
     */
    private String reason;
    /**
     * 是否使用时间戳，true：是
     */
    private Boolean timestampFlag;
    /**
     * 时间戳时间，有则与签章时间一致
     */
    private String timestampTime;
    /**
     * 时间戳是否验证通过
     */
    private Boolean timestampVerifyFlag;
    /**
     * 证书ou信息盖章机构
     */
    private String ou;
    /**
     * 证书指纹值
     */
    private String certSHA1;
    /**
     * 证书开始时间
     */
    private String certBeginTime;
    /**
     * 证书结束时间
     */
    private String certEndTime;
}
