package com.dss.sdk.api.dto;

import com.dss.sdk.annotation.ValidField;

@lombok.Data
public class MobileVerificationInfo {
    /**
     * 区号，手机号区号，不传值则默认为+86
     */
    private String areaCode = "+86";
    /**
     * 手机号，手机号码
     */
    @ValidField(required = true)
    private String mobile;
    /**
     * 验证码，短信验证码
     */
    @ValidField(required = true, maxLength = 6)
    private String verificationCode;
    /**
     * 验证结果时间，验证结果时间
     */
    private String verificationFinishTime;
}
