package com.dss.sdk.api.dto;

import java.util.Date;

/**
 * FileSignSignResponse
 */
@lombok.Data
public class SignResponseData {
    /**
     * 文件ID，文件在本地电子签系统的唯一识别标识
     */
    private String fileId;
    /**
     * 文件名称，已签署文件名称（含文件后缀）
     */
    private String fileName;
    /**
     * 文件下载地址，文件下载地址，连接一次有效，失效后可重复获取
     */
    private String fileUrl;
    /**
     * 签署时间，签署时间，格式yyyy-MM-dd HH:mm:ss
     */
    private Date signDate;
    /**
     * 签署前Hash，签署前的文件Hash
     */
    private String beforeFileHash;
    /**
     * 签署后Hash，签署后的文件Hash
     */
    private String afterFileHash;
}
