package com.dss.sdk.api.dto;

import com.dss.sdk.api.enums.ApiWatermarkPositionTypeEnum;
import lombok.Data;

/**
 * 水印信息list，需支持传入多个
 */
@Data
public class WatermarkInfo {
    /**
     * 水印类型，1-文字；2-图片；3、文档编号
     */
    private String type;
    // =============  文字水印相关字段 ================
    /**
     * 文字水印内容，当水印类型为1时，必填。 文字长度限制：20个字
     */
    private String text;
    /**
     * 字体大小，当水印类型为1时，必填。 字体取值范围6-48的整数。
     */
    private Integer fontSize;
    /**
     * 字体颜色，默认为#000000
     */
    private String fontColor = "#000000";
    // =============  图片水印相关字段 ================
    /**
     * 水印图片base64，当水印类型为2时，必填。 图片类型：仅限png、jpg、jpeg； 图片尺寸：不超过595*842； 图片大小：不超过300kb。
     */
    // 300 * 1024 * 4 / 3 = 409600  (由于Base64原理，实际大小为原图文件大小的4/3)
    private String imageBase64;
    /**
     * 图片宽度，当水印类型为2时，必填。 图片宽度取值范围0-595。
     */
//    
    private Float imageWidth;
    /**
     * 图片高度，当水印类型为2时，必填。 图片高度取值范围0-842。
     */
//    
    private Float imageHeight;
    // =============  水印基础信息 ================
    /**
     * 旋转角度，默认不旋转。0-180
     */
    private Float rotate = 0.0f;
    /**
     * 透明度，10-90%的整拾数（默认40%）
     */
    private Integer opacity = 40;
    /**
     * 水印的密集度，PDF横向和纵向水印的个数，默认为1
     */
    //
//    
//    private Integer concentrationFactor = 1;
    /**
     * 水印位置，可指定当前设置水印位置，6个样式：左上（默认）、右上、左下、右下、平铺、填充（填充平铺到页面80%占比即可）不传则取默认值
     * upper_left: 左上；upper_right: 右上；lower_left: 左下；lower_right: 右下
     */
    private String positionType = ApiWatermarkPositionTypeEnum.UPPER_LEFT.getReadValue();
}
