package com.dss.sdk.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum AccessTypeEnum implements ReadableEnum<AccessTypeEnum> {

    UNLIMITED("unlimited", "不做访问限制（默认）"),
    ACCESSCODE ("accessCode", "访问码"),
    VERIFIEDCODE ("verifiedCode", "手机验证码"),
    ;

    private final String code;
    private final String desc;

    @Override
    public String getReadValue() {
        return code;
    }

}
