package com.dss.sdk.api.enums;

import lombok.Getter;

/**
 * 印章文本对齐方式
 *
 * @author Fadada
 * @since 2024/05/08 11:28
 */
@Getter
public enum AlignTypeEnum implements ReadableEnum<AlignTypeEnum> {

    /**
     * 印章文本对齐方式
     **/
    LEFT("left", "左对齐"),
    CENTER("center", "居中"),
    RIGHT("right", "右对齐");

    /**
     * 字段值
     */
    private final String type;
    /**
     * 字段值的实际意义
     */
    private final String value;

    AlignTypeEnum(String type, String value) {
        this.type = type;
        this.value = value;
    }

    @Override
    public String getReadValue() {
        return type;
    }
}
