package com.dss.sdk.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.ArrayList;
import java.util.List;

/**
 * <h3>概要:</h3>
 * 水印位置类型
 * <br>
 * <h3>功能:</h3>
 * <ol>
 *
 * </ol>
 * <h3>履历:</h3>
 * <ol>
 * 		<li>2020年1月7日[SUXH] 新建</li>
 * </ol>
 */
@Getter
@AllArgsConstructor
public enum ApiWatermarkPositionTypeEnum implements ReadableEnum<ApiWatermarkPositionTypeEnum> {
    // 下面四个类型是底层SDK支持的，见 WatermarkPositionTypeEnum
    UPPER_LEFT(0, "左上", 1),
    UPPER_RIGHT(1, "右上", 1),
    LOWER_LEFT(2, "左下", 1),
    LOWER_RIGHT(3, "右下", 1),
    // 下面两个枚举类型底层SDK并不支持，是为了扩充支持的类型，通过concentrationFactor字段改变水印密度实现的
    TILE(4, "平铺", 4),
    FILL(5, "填充", 8),
    ;
    /**
     * 字段值
     */
    private Integer value;
    /**
     * 字段值的实际意义
     */
    private String valueInFact;
    /**
     * 水印密集度
     */
    private Integer concentrationFactor;

    /**
     * <b>概要：</b>
     * 根据属性值匹配属性
     * <b>作者：</b>SUXH </br>
     * <b>日期：</b>2015-3-17 </br>
     *
     * @param value 需要匹配的属性值
     * @return
     */
    public static ApiWatermarkPositionTypeEnum convertByValue(Integer value) {
        for (ApiWatermarkPositionTypeEnum watermarkPositionTypeEnum : ApiWatermarkPositionTypeEnum.values()) {
            if (watermarkPositionTypeEnum.getValue().equals(value)) {
                return watermarkPositionTypeEnum;
            }
        }
        return null;
    }

    /**
     * <b>概要：</b>
     * 获得枚举的所有值（all value）
     * <b>作者：</b>SUXH </br>
     * <b>日期：</b>2015-3-31 </br>
     *
     * @return 枚举的所有值
     */
    public static List<Integer> getValueList() {
        List<Integer> values = new ArrayList<Integer>();
        ApiWatermarkPositionTypeEnum[] watermarkPositionTypeEnumArr = ApiWatermarkPositionTypeEnum.values();
        for (ApiWatermarkPositionTypeEnum i : watermarkPositionTypeEnumArr) {
            values.add(i.getValue());
        }
        return values;
    }

    @Override
    public String getReadValue() {
        return name().toLowerCase();
    }
}
