package com.dss.sdk.api.enums;

import com.dss.sdk.utils.string.StrUtil;
import lombok.Getter;

/**
 * 印章图片格式
 *
 * @author Fadada
 * @since 2024/05/08 11:28
 */
@Getter
public enum BoldEnum implements ReadableEnum<BoldEnum> {

    /**
     * 印章样式
     **/
    REGULAR("regular", "不加粗"),
    BOLD("bold", "加粗");

    /**
     * 字段值
     */
    private final String type;
    /**
     * 字段值的实际意义
     */
    private final String value;

    BoldEnum(String type, String value) {
        this.type = type;
        this.value = value;
    }

    public static Boolean isBold(String bold) {
        if (StrUtil.isEmpty(bold)) {
            // 默认不加粗
            return Boolean.FALSE;
        }
        return BOLD.getType().equalsIgnoreCase(bold);
    }

    @Override
    public String getReadValue() {
        return type;
    }
}
