package com.dss.sdk.api.enums;

import java.util.ArrayList;
import java.util.List;

/**
 * <h3>概要:</h3>
 * 单元格的垂直对齐方式-4：居上；5：居中；6：居下  与Element.class对应
 * <br>
 * <h3>功能:</h3>
 * <ol>
 *
 * </ol>
 * <h3>履历:</h3>
 * <ol>
 * 		<li>2016-8-31[suxh] 新建</li>
 * </ol>
 */
public enum CellVerticalAlignmentEnum implements ReadableEnum<CellVerticalAlignmentEnum> {
    ALIGN_TOP(4, "居上"),
    ALIGN_MIDDLE(5, "居中"),
    ALIGN_BOTTOM(6, "居下");
    /**
     * 字段值
     */
    private Integer value;
    /**
     * 字段值的实际意义
     */
    private String valueInFact;

    CellVerticalAlignmentEnum(Integer value, String valueInFact) {
        this.value = value;
        this.valueInFact = valueInFact;
    }

    /**
     * <b>概要：</b>
     * 根据属性值匹配属性
     * <b>作者：</b>SUXH </br>
     * <b>日期：</b>2015-3-17 </br>
     *
     * @param value 需要匹配的属性值
     * @return
     */
    public static CellVerticalAlignmentEnum convertByValue(String value) {
        for (CellVerticalAlignmentEnum cellVerticalAlignmentEnum : CellVerticalAlignmentEnum.values()) {
            if (cellVerticalAlignmentEnum.getValue().equals(value)) {
                return cellVerticalAlignmentEnum;
            }
        }
        return null;
    }

    /**
     * <b>概要：</b>
     * 获得枚举的所有值（all value）
     * <b>作者：</b>SUXH </br>
     * <b>日期：</b>2015-3-31 </br>
     *
     * @return 枚举的所有值
     */
    public static List<Integer> getValueList() {
        List<Integer> values = new ArrayList<Integer>();
        CellVerticalAlignmentEnum[] cellVerticalAlignmentEnumArr = CellVerticalAlignmentEnum.values();
        for (CellVerticalAlignmentEnum i : cellVerticalAlignmentEnumArr) {
            values.add(i.getValue());
        }
        return values;
    }

    /**
     * 判断参数合法性
     */
    public static boolean isValidKey(Integer key) {
        return getValueList().contains(key);
    }

    public Integer getValue() {
        return value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    public String getValueInFact() {
        return valueInFact;
    }

    public void setValueInFact(String valueInFact) {
        this.valueInFact = valueInFact;
    }

    @Override
    public String getReadValue() {
        return name().toLowerCase();
    }
}
