package com.dss.sdk.api.enums;

import lombok.Getter;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Fadada
 * @Title:证书算法
 * @Description:
 */
@Getter
public enum CertAlgEnum implements ReadableEnum<CertAlgEnum> {
    /**
     * RSA
     */
    RSA("RSA", "RSA算法"),
    /**
     * SM2
     */
    SM2("SM2", "SM2算法"),
    /**
     * 两个算法都要
     */
    ALL("ALL", "两个算法都要");

    private final String value;

    private final String caName;

    CertAlgEnum(String value, String caName) {
        this.value = value;
        this.caName = caName;
    }

    /**
     * <b>概要：</b>
     * 获得枚举的所有值（all value）
     * <b>作者：</b>SUXH </br>
     * <b>日期：</b>2015-3-31 </br>
     *
     * @return 枚举的所有值
     */
    public static List<String> getValueList() {
        List<String> values = new ArrayList<String>();
        CertAlgEnum[] picFlagEnumArr = CertAlgEnum.values();
        for (CertAlgEnum i : picFlagEnumArr) {
            values.add(i.getValue());
        }
        return values;
    }

    public static boolean isValidKey(String key) {
        return key == null || (key != null && getValueList().contains(key));
    }

    @Override
    public String getReadValue() {
        return value;
    }
}
