package com.dss.sdk.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;


@Getter
@AllArgsConstructor
public enum CoordOriginEnum {
    LEFT_TOP("left_top", "左上角", "left", "top"),
    LEFT_BOTTOM("left_bottom", "左下角", "left", "bottom");

    private final String code;
    private final String desc;
    private final  String x;
    private final String y;

    public static CoordOriginEnum convertByCode(String code) {
        for (CoordOriginEnum value : values()) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        return null;

    }
}
