package com.dss.sdk.api.enums;

import lombok.Getter;

@Getter
public enum CorpTypeEnum implements ReadableEnum<CorpTypeEnum> {

    COMPANY("company", "企业"),
    INDIVIDUAL_BUSINESS("individual_business", "个体工商户"),
    OTHERS("others", "其他组织");

    /**
     * 字段值
     */
    private final String type;
    /**
     * 字段值的实际意义
     */
    private final String value;

    CorpTypeEnum(String type, String value) {
        this.type = type;
        this.value = value;
    }

    @Override
    public String getReadValue() {
        return type;
    }
}
