package com.dss.sdk.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum EuiPageTypeEnum implements ReadableEnum<EuiPageTypeEnum> {

    PC("pc", "PC端"),
    H5("h5", "H5端"),
    ADAPTIVE("adaptive", "自适应端"),
    ;

    private final String code;
    private final String desc;

    public static boolean isH5(String pageType) {
        return H5.getCode().equals(pageType);
    }

    public static boolean isPc(String pageType) {
        return PC.getCode().equals(pageType);
    }

    @Override
    public String getReadValue() {
        return code;
    }
}
