package com.dss.sdk.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum FileTypeEnum implements ReadableEnum<FileTypeEnum> {
    /**
     *
     */
    PDF_FILE(1, "pdf", ".pdf", "pdf文件类型"),
    OFD_FILE(2, "ofd", ".ofd", "ofd文件类型");
    private Integer type;
    private String name;
    private String suffix;
    private String desc;

    public static boolean isValidKey(Integer type) {
        if (null == type) {
            //为空也可以
            return true;
        }
        for (FileTypeEnum value : FileTypeEnum.values()) {
            if (value.getType().equals(type)) {
                return true;
            }
        }
        return false;
    }

    public static FileTypeEnum getFileType(Integer type) {
        for (FileTypeEnum value : FileTypeEnum.values()) {
            if (value.getType().equals(type)) {
                return value;
            }
        }
        return null;
    }

    public static FileTypeEnum getByName(String name) {
        for (FileTypeEnum value : FileTypeEnum.values()) {
            if (value.getName().equals(name)) {
                return value;
            }
        }
        return null;
    }

    // with default
    public static FileTypeEnum getByName(String name, FileTypeEnum defaultEnum) {
        for (FileTypeEnum value : FileTypeEnum.values()) {
            if (value.getName().equals(name)) {
                return value;
            }
        }
        return defaultEnum;
    }

    public static FileTypeEnum getByNameIgnoreCase(String name) {
        for (FileTypeEnum value : FileTypeEnum.values()) {
            if (value.getName().equalsIgnoreCase(name)) {
                return value;
            }
        }
        return null;
    }

    public static FileTypeEnum getBySuffix(String suffix) {
        for (FileTypeEnum value : FileTypeEnum.values()) {
            if (value.getSuffix().equals(suffix)) {
                return value;
            }
        }
        return null;
    }

    public static boolean isPdfOrOfd(String name) {
        return PDF_FILE.getName().equalsIgnoreCase(name) || OFD_FILE.getName().equalsIgnoreCase(name);
    }

    public static boolean isPdf(String name) {
        return PDF_FILE.getName().equalsIgnoreCase(name);
    }

    public static boolean isOfd(String name) {
        return OFD_FILE.getName().equalsIgnoreCase(name);
    }

    public static boolean isOfd(Integer type) {
        return OFD_FILE.getType().equals(type);
    }

    public static boolean isPdfOrOfd(FileTypeEnum typeEnum) {
        return PDF_FILE.equals(typeEnum) || OFD_FILE.equals(typeEnum);
    }

    @Override
    public String getReadValue() {
        return this.name;
    }
}
