package com.dss.sdk.api.enums;

import java.util.ArrayList;
import java.util.List;

/**
 * <h3>概要:</h3>
 * 填充pdf字体设定：0：宋体；1：仿宋；2、黑体；3、楷体。
 * <br>
 * <h3>功能:</h3>
 * <ol>
 *
 * </ol>
 * <h3>履历:</h3>
 * <ol>
 * 		<li>2015-3-17[SUXH] 新建</li>
 * </ol>
 */
public enum FillInPdfReqFontTypeEnum implements ReadableEnum<FillInPdfReqFontTypeEnum> {
    /**
     * 宋体
     */
    SONG_TI(0, "simsun", "宋体", "simsun.ttf"),
    /**
     * 仿宋
     */
    FANG_SONG(1, "simfang", "仿宋", "simfang.ttf"),
    /**
     * 黑体
     */
    HEI_TI(2, "simhei", "黑体", "simhei.ttf"),
    /**
     * 楷体
     */
    KAI_TI(3, "simkai", "楷体", "simkai.ttf"),
    /**
     * 微软雅黑
     */
    MICROSOFY_YA_HEI(4, "msyh", "微软雅黑", "msyh.ttf"),
    /**
     * TIME_NEW_ROMAN
     */
    TIME_NEW_ROMAN(5, "times", "TIME_NEW_ROMAN", "times.ttf"),
    /**
     * arial
     */
    ARIAL(6, "arial", "arial", "arialuni.ttf"),
    /**
     * 思源宋体 Noto Sans CJK TC Regular
     */
    Noto_Sans_CJK_TC_Regular(7, "syst", "思源宋体Noto Sans CJK TC Regular", "Noto Sans CJK TC Regular.otf");
    /**
     * 字段值
     */
    private Integer value;
    private String readValue;
    /**
     * 字段值的实际意义
     */
    private String valueInFact;
    /**
     * 字体文件名称
     */
    private String fontFileName;

    FillInPdfReqFontTypeEnum(Integer value, String valueInFact, String fontFileName) {
        this.value = value;
        this.valueInFact = valueInFact;
        this.fontFileName = fontFileName;
    }

    FillInPdfReqFontTypeEnum(Integer value, String readValue, String valueInFact, String fontFileName) {
        this.value = value;
        this.readValue = readValue;
        this.valueInFact = valueInFact;
        this.fontFileName = fontFileName;
    }

    /**
     * <b>概要：</b>
     * 根据属性值匹配属性
     * <b>作者：</b>SUXH </br>
     * <b>日期：</b>2015-3-17 </br>
     *
     * @param value 需要匹配的属性值
     * @return
     */
    public static FillInPdfReqFontTypeEnum convertByValue(Integer value) {
        for (FillInPdfReqFontTypeEnum fillInPdfReqFontTypeEnum : FillInPdfReqFontTypeEnum.values()) {
            if (fillInPdfReqFontTypeEnum.getValue().equals(value)) {
                return fillInPdfReqFontTypeEnum;
            }
        }
        return null;
    }

    /**
     * <b>概要：</b>
     * 获得枚举的所有值（all value）
     * <b>作者：</b>SUXH </br>
     * <b>日期：</b>2015-3-31 </br>
     *
     * @return 枚举的所有值
     */
    public static List<String> getValueList() {
        List<String> values = new ArrayList<String>();
        FillInPdfReqFontTypeEnum[] fillInPdfReqFontTypeEnumArr = FillInPdfReqFontTypeEnum.values();
        for (FillInPdfReqFontTypeEnum i : fillInPdfReqFontTypeEnumArr) {
            values.add(i.getValue().toString());
        }
        return values;
    }

    public Integer getValue() {
        return this.value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    public String getValueInFact() {
        return valueInFact;
    }

    public void setValueInFact(String valueInFact) {
        this.valueInFact = valueInFact;
    }

    public String getFontFileName() {
        return fontFileName;
    }

    public void setFontFileName(String fontFileName) {
        this.fontFileName = fontFileName;
    }

    @Override
    public String getReadValue() {
        return readValue;
    }
}
