package com.dss.sdk.api.enums;

import java.util.ArrayList;
import java.util.List;

/**
 * <h3>概要:</h3>
 * 发OSS渠道
 * <br>
 * <h3>功能:</h3>
 * <ol>
 *
 * </ol>
 * <h3>履历:</h3>
 * <ol>
 * 		<li>2016-8-31[suxh] 新建</li>
 * </ol>
 */
public enum FormChooseStyleEnum implements ReadableEnum<FormChooseStyleEnum> {
    CHECK(1, "勾形"),
    CIRCLE(2, "圆形"),
    CROSS(3, "叉形"),
    DIAMOND(4, "菱形"),
    SQUARE(5, "正方形"),
    STAR(6, "星形");
    /**
     * 字段值
     */
    private Integer value;
    /**
     * 字段值的实际意义
     */
    private String valueInFact;

    FormChooseStyleEnum(Integer value, String valueInFact) {
        this.value = value;
        this.valueInFact = valueInFact;
    }

    /**
     * <b>概要：</b>
     * 根据属性值匹配属性
     * <b>作者：</b>SUXH </br>
     * <b>日期：</b>2015-3-17 </br>
     *
     * @param value 需要匹配的属性值
     * @return
     */
    public static FormChooseStyleEnum convertByValue(String value) {
        for (FormChooseStyleEnum formChooseStyleEnum : FormChooseStyleEnum.values()) {
            if (formChooseStyleEnum.getValue().equals(value)) {
                return formChooseStyleEnum;
            }
        }
        return null;
    }

    /**
     * <b>概要：</b>
     * 获得枚举的所有值（all value）
     * <b>作者：</b>SUXH </br>
     * <b>日期：</b>2015-3-31 </br>
     *
     * @return 枚举的所有值
     */
    public static List<Integer> getValueList() {
        List<Integer> values = new ArrayList<Integer>();
        FormChooseStyleEnum[] formChooseStyleEnumArr = FormChooseStyleEnum.values();
        for (FormChooseStyleEnum i : formChooseStyleEnumArr) {
            values.add(i.getValue());
        }
        return values;
    }

    /**
     * 判断参数合法性
     */
    public static boolean isValidKey(Integer key) {
        return getValueList().contains(key);
    }

    public Integer getValue() {
        return value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    public String getValueInFact() {
        return valueInFact;
    }

    public void setValueInFact(String valueInFact) {
        this.valueInFact = valueInFact;
    }

    @Override
    public String getReadValue() {
        return name().toLowerCase();
    }
}
