package com.dss.sdk.api.enums;

import lombok.Getter;

@Getter
public enum FormDataEnum implements ReadableEnum<FormDataEnum> {

    TEXT(1, "text", "文本类型", false),
    PIC_URL(2, "picUrl", "jpg/png图片URL地址", true),
    PIC_BASE64(3, "picBase64", "jpg/png图片base64", true),
    SVG_URL(4, "svgUrl", "svg文件URL地址", true),
    SVG_BASE64(5, "svgBase64", "svg图片内容", true),
    DATE(6, "date", "日期类型", false),
    RADIO(7, "radio", "单选", false),
    CHECKBOX(7, "checkbox", "多选", false),
    ;

    public static FormDataEnum getEnumByType(Integer type) {
        if (null == type) {
            return null;
        }
        for (FormDataEnum value : FormDataEnum.values()) {
            if (value.getType().equals(type)) {
                return value;
            }
        }
        return null;
    }

    public static boolean isValidKey(Integer type) {
        for (FormDataEnum value : FormDataEnum.values()) {
            if (value.getType() == type) {
                return true;
            }
        }
        return false;
    }

    private Integer type;

    private String readValue;

    private String desc;

    private Boolean isImage;

    FormDataEnum(Integer type, String readValue, String desc, Boolean isImage) {
        this.type = type;
        this.readValue = readValue;
        this.desc = desc;
        this.isImage = isImage;
    }

}
