package com.dss.sdk.api.enums;

import lombok.Getter;

@Getter
public enum IdCertTypeEnum implements ReadableEnum<IdCertTypeEnum> {
    IDENTITY_CARD("identity_card", "中国居民身份证"),
    PASSPORT("passport", "护照"),
    TRAVEL_PERMIT_HK_MACAO("travel_permit_hk_macao", "港澳居民来往内地通行证"),
    TRAVEL_PERMIT_TAIWAN("travel_permit_taiwan", "台湾居民来往大陆通行证"),
    FOREIGN_PERMANENT_RESIDENT_ID_CARD("foreign_permanent_resident_id_card", "外国人永久居留身份证"),
    HK_MACAO_RESIDENT_ID_CARD("hk_macao_resident_id_card", "港澳居民居住证"),
    TAIWAN_RESIDENT_ID_CARD("taiwan_resident_id_card", "台湾居民居住证");

    /**
     * 字段值
     */
    private final String type;
    /**
     * 字段值的实际意义
     */
    private final String value;

    IdCertTypeEnum(String type, String value) {
        this.type = type;
        this.value = value;
    }

    @Override
    public String getReadValue() {
        return type;
    }
}
