package com.dss.sdk.api.enums;

import lombok.AllArgsConstructor;

import java.util.ArrayList;
import java.util.List;

/**
 * <h3>概要:</h3>
 * 插入表格的方式：①新建页面添加table;②在某个关键字后添加table(多个关键字，则为第一个关键字)
 * <br>
 * <h3>功能:</h3>
 * <ol>
 *
 * </ol>
 * <h3>履历:</h3>
 * <ol>
 * 		<li>2017-8-7[SUXH] 新建</li>
 * </ol>
 */
@AllArgsConstructor
public enum InsertWayEnum implements ReadableEnum<InsertWayEnum> {
    NEW_PAGE(0, "新建页面添加table", "new_page"),
    INSERT_BY_KEYWORD(1, "在某个关键字后添加table(多个关键字，则为第一个关键字)", "keyword"),
    INSERT_BY_PAGE_AND_Y(2, "根据页面及Y坐标添加table", "location"),
    ;
    /**
     * 字段值
     */
    private Integer value;
    /**
     * 字段值的实际意义
     */
    private String valueInFact;
    private String readValue;

    InsertWayEnum(Integer value, String valueInFact) {
        this.value = value;
        this.valueInFact = valueInFact;
    }

    /**
     * <b>概要：</b>
     * 根据属性值匹配属性
     * <b>作者：</b>SUXH </br>
     * <b>日期：</b>2015-3-17 </br>
     *
     * @param value 需要匹配的属性值
     * @return
     */
    public static InsertWayEnum convertByValue(String value) {
        for (InsertWayEnum tableInsertWayEnum : InsertWayEnum.values()) {
            if (tableInsertWayEnum.getValue().equals(value)) {
                return tableInsertWayEnum;
            }
        }
        return null;
    }

    /**
     * <b>概要：</b>
     * 获得枚举的所有值（all value）
     * <b>作者：</b>SUXH </br>
     * <b>日期：</b>2015-3-31 </br>
     *
     * @return 枚举的所有值
     */
    public static List<Integer> getValueList() {
        List<Integer> values = new ArrayList<Integer>();
        InsertWayEnum[] tableInsertWayEnumArr = InsertWayEnum.values();
        for (InsertWayEnum i : tableInsertWayEnumArr) {
            values.add(i.getValue());
        }
        return values;
    }

    /**
     * 判断参数合法性
     */
    public static boolean isValidKey(Integer key) {
        return getValueList().contains(key);
    }

    public Integer getValue() {
        return value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    public String getValueInFact() {
        return valueInFact;
    }

    public void setValueInFact(String valueInFact) {
        this.valueInFact = valueInFact;
    }

    @Override
    public String getReadValue() {
        return readValue;
    }
}
